/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.Serializable;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.EqualityAssert;
import org.marketcetera.util.test.SerializableAssert;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.wrappers.MarshalledLocale;

public class MarshalledLocaleTest
extends TestCaseBase {
    private static final String TEST_LANGUAGE = "language";
    private static final String TEST_COUNTRY = "COUNTRY";
    private static final String TEST_VARIANT = "variant";
    public static final Locale TEST_LOCALE = new Locale("language", "COUNTRY", "variant");

    @Test
    public void all() {
        MarshalledLocale m = new MarshalledLocale(TEST_LOCALE);
        Assert.assertEquals((Object)TEST_LANGUAGE, (Object)m.getLanguage());
        Assert.assertEquals((Object)TEST_COUNTRY, (Object)m.getCountry());
        Assert.assertEquals((Object)TEST_VARIANT, (Object)m.getVariant());
        Assert.assertEquals((Object)TEST_LOCALE, (Object)m.toLocale());
        MarshalledLocale copy = new MarshalledLocale(TEST_LOCALE);
        MarshalledLocale empty = new MarshalledLocale();
        Assert.assertNull((Object)empty.getLanguage());
        Assert.assertNull((Object)empty.getCountry());
        Assert.assertNull((Object)empty.getVariant());
        Assert.assertNull((Object)empty.toLocale());
        EqualityAssert.assertEquality((Object)m, (Object)copy, (Object[])new Object[]{empty});
        EqualityAssert.assertEquality((Object)empty, (Object)new MarshalledLocale(null), (Object[])new Object[0]);
        SerializableAssert.assertSerializable((Serializable)m);
        Assert.assertEquals((Object)TEST_LOCALE.toString(), (Object)m.toString());
        Assert.assertEquals((Object)"", (Object)empty.toString());
        m.setVariant(null);
        Assert.assertEquals((Object)TEST_LANGUAGE, (Object)m.getLanguage());
        Assert.assertEquals((Object)TEST_COUNTRY, (Object)m.getCountry());
        Assert.assertNull((Object)m.getVariant());
        Assert.assertEquals((Object)new Locale(TEST_LANGUAGE, TEST_COUNTRY), (Object)m.toLocale());
        m.setCountry(null);
        Assert.assertEquals((Object)TEST_LANGUAGE, (Object)m.getLanguage());
        Assert.assertNull((Object)m.getCountry());
        Assert.assertNull((Object)m.getVariant());
        Assert.assertEquals((Object)new Locale(TEST_LANGUAGE), (Object)m.toLocale());
        m.setLanguage(null);
        Assert.assertNull((Object)m.getLanguage());
        Assert.assertNull((Object)m.getCountry());
        Assert.assertNull((Object)m.getVariant());
        Assert.assertNull((Object)m.toLocale());
        Assert.assertEquals((Object)empty, (Object)m);
        m.setVariant(TEST_VARIANT);
        Assert.assertEquals((Object)empty, (Object)m);
        m.setCountry(TEST_COUNTRY);
        Assert.assertEquals((Object)empty, (Object)m);
        m.setLanguage(TEST_LANGUAGE);
        Assert.assertEquals((Object)copy, (Object)m);
    }
}

