/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.Closeable;
import java.util.LinkedList;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.file.Messages;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: CloseableRegistry.java 16154 2012-07-14 16:34:05Z colin $")
public class CloseableRegistry
implements Closeable {
    private LinkedList<Closeable> mRegistry = new LinkedList();

    public void register(Closeable closeable) {
        this.mRegistry.addFirst(closeable);
    }

    @Override
    public void close() {
        for (Closeable closeable : this.mRegistry) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                ExceptUtils.swallow(t, this, Messages.CLOSING_FAILED);
            }
        }
    }
}

