/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.ContextClassProvider;
import org.marketcetera.util.ws.stateful.AuthService;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateful.Messages;
import org.marketcetera.util.ws.stateless.StatelessClient;
import org.marketcetera.util.ws.tags.AppId;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id: Client.java 16853 2014-03-06 02:10:11Z colin $")
public class Client
extends StatelessClient {
    private SessionId mSessionId;

    public Client(String inHost, int inPort, AppId inAppId, ContextClassProvider inContextClassProvider) {
        super(inHost, inPort, inAppId, inContextClassProvider);
    }

    public Client(String host, int port, AppId appId) {
        super(host, port, appId);
    }

    public Client(AppId appId) {
        this("0.0.0.0", 9000, appId);
    }

    public Client() {
        this(null);
    }

    private void setSessionId(SessionId sessionId) {
        this.mSessionId = sessionId;
    }

    public SessionId getSessionId() {
        return this.mSessionId;
    }

    public void assertValidSession() throws I18NException {
        if (this.getSessionId() == null) {
            throw new I18NException(Messages.NOT_LOGGED_IN);
        }
    }

    public void login(String user, char[] password) throws I18NException, RemoteException {
        if (this.getSessionId() != null) {
            throw new I18NException(Messages.ALREADY_LOGGED_IN);
        }
        AuthService i = this.getService(AuthService.class);
        this.setSessionId(i.login(super.getContext(), user, password));
    }

    public void logout() throws RemoteException {
        AuthService i = this.getService(AuthService.class);
        i.logout(this.getContext());
        this.setSessionId(null);
    }

    @Override
    public ClientContext getContext() {
        ClientContext context = new ClientContext();
        this.fillContext(context);
        context.setSessionId(this.getSessionId());
        return context;
    }
}

