/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateless;

import java.lang.annotation.Annotation;
import javax.jws.WebService;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.tags.NodeId;

@ClassVersion(value="$Id: Node.java 16853 2014-03-06 02:10:11Z colin $")
public class Node {
    private String host;
    private int port;
    private final NodeId nodeId = NodeId.generate();
    public static final int DEFAULT_PORT = 9000;
    public static final String DEFAULT_HOST = "0.0.0.0";

    public void setHost(String inHost) {
        this.host = inHost;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int inPort) {
        this.port = inPort;
    }

    public NodeId getId() {
        return this.nodeId;
    }

    protected Node(String inHost, int inPort) {
        this.host = inHost;
        this.port = inPort;
    }

    protected Node() {
        this(DEFAULT_HOST, 9000);
    }

    protected String getConnectionUrl(Class<?> inInterfaceClazz) {
        String targetNamespace = null;
        for (Annotation annotation : inInterfaceClazz.getDeclaredAnnotations()) {
            if (!(annotation instanceof WebService)) continue;
            WebService webServiceAnnotation = (WebService)annotation;
            targetNamespace = webServiceAnnotation.targetNamespace();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("http://");
        builder.append(this.getHost());
        builder.append(':');
        builder.append(this.getPort());
        builder.append('/');
        if (targetNamespace == null) {
            builder.append(inInterfaceClazz.getName().replace('.', '_').replace('$', '_'));
        } else {
            builder.append(targetNamespace);
        }
        return builder.toString();
    }
}

