/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.tags;

import java.io.Serializable;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.tags.Messages;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.tags.Tag;
import org.marketcetera.util.ws.tags.TagFilter;

@ClassVersion(value="$Id: ValidSessionTagFilter.java 16154 2012-07-14 16:34:05Z colin $")
public class ValidSessionTagFilter<T>
implements TagFilter {
    private final SessionManager<T> mSessionManager;

    public ValidSessionTagFilter(SessionManager<T> sessionManager) {
        this.mSessionManager = sessionManager;
    }

    public SessionManager<T> getSessionManager() {
        return this.mSessionManager;
    }

    @Override
    public void assertMatch(Tag tag) throws I18NException {
        if (this.getSessionManager() == null) {
            return;
        }
        if (tag == null) {
            throw new I18NException(Messages.SESSION_REQUIRED);
        }
        if (tag instanceof SessionId && this.getSessionManager().get((SessionId)tag) != null) {
            return;
        }
        throw new I18NException(new I18NBoundMessage1P(Messages.SESSION_EXPIRED, (Serializable)tag));
    }
}

