/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.except;

import java.io.InterruptedIOException;
import java.io.Serializable;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileLockInterruptionException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.UnknownObjectException;
import javax.naming.InterruptedNamingException;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.except.I18NInterruptedException;
import org.marketcetera.util.except.I18NInterruptedRuntimeException;
import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.except.I18NThrowableTestBase;
import org.marketcetera.util.except.TestMessages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;

public class ExceptUtilsTest
extends I18NThrowableTestBase {
    private static final String TEST_CATEGORY;
    private static final String TEST_LOCATION;

    private static void interruptHelper(Exception ex, boolean interrupted) {
        Assert.assertEquals((Object)interrupted, (Object)ExceptUtils.interrupt((Throwable)ex));
        Assert.assertEquals((Object)interrupted, (Object)Thread.interrupted());
    }

    private void swallowHelper(Exception ex, boolean interrupted) {
        Assert.assertEquals((Object)interrupted, (Object)ExceptUtils.swallow((Throwable)ex, (Object)TEST_CATEGORY, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))));
        Assert.assertEquals((Object)interrupted, (Object)Thread.interrupted());
        this.assertSingleEvent(Level.WARN, TEST_CATEGORY, "Middle-level test exception (expected) a", TEST_LOCATION);
        Assert.assertEquals((Object)interrupted, (Object)ExceptUtils.swallow((Throwable)ex));
        Assert.assertEquals((Object)interrupted, (Object)Thread.interrupted());
        this.assertSingleEvent(Level.WARN, TEST_CATEGORY, "Caught throwable was not propagated", TEST_LOCATION);
    }

    private static void wrapHelper(Exception ex, boolean interruption) {
        I18NException out = ExceptUtils.wrap((Throwable)ex, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
        Assert.assertEquals((String)out.getDetail(), (Object)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")), (Object)out.getI18NBoundMessage());
        Assert.assertEquals((Object)ex, (Object)out.getCause());
        Assert.assertTrue((boolean)(out instanceof I18NException));
        Assert.assertEquals((Object)interruption, (Object)(out instanceof I18NInterruptedException));
        Assert.assertEquals((Object)interruption, (Object)Thread.interrupted());
        out = ExceptUtils.wrap((Throwable)ex);
        Assert.assertEquals((Object)ex, (Object)out.getCause());
        Assert.assertTrue((boolean)(out instanceof I18NException));
        Assert.assertEquals((Object)interruption, (Object)(out instanceof I18NInterruptedException));
        Assert.assertEquals((Object)interruption, (Object)Thread.interrupted());
        I18NRuntimeException outR = ExceptUtils.wrapRuntime((Throwable)ex, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
        Assert.assertEquals((String)outR.getDetail(), (Object)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")), (Object)outR.getI18NBoundMessage());
        Assert.assertEquals((Object)ex, (Object)outR.getCause());
        Assert.assertTrue((boolean)(outR instanceof I18NRuntimeException));
        Assert.assertEquals((Object)interruption, (Object)(outR instanceof I18NInterruptedRuntimeException));
        Assert.assertEquals((Object)interruption, (Object)Thread.interrupted());
        outR = ExceptUtils.wrapRuntime((Throwable)ex);
        Assert.assertEquals((Object)ex, (Object)outR.getCause());
        Assert.assertTrue((boolean)(outR instanceof I18NRuntimeException));
        Assert.assertEquals((Object)interruption, (Object)(outR instanceof I18NInterruptedRuntimeException));
        Assert.assertEquals((Object)interruption, (Object)Thread.interrupted());
    }

    private static void equalityHelper(Throwable t1, Throwable t2, Throwable[] diffs) {
        Assert.assertTrue((boolean)ExceptUtils.areEqual((Throwable)t1, (Object)t1));
        Assert.assertTrue((boolean)ExceptUtils.areEqual((Throwable)t1, (Object)t2));
        Assert.assertTrue((boolean)ExceptUtils.areEqual((Throwable)t2, (Object)t1));
        Assert.assertNotSame((Object)t1, (Object)t2);
        for (Throwable t : diffs) {
            Assert.assertFalse((boolean)ExceptUtils.areEqual((Throwable)t1, (Object)t));
            Assert.assertFalse((boolean)ExceptUtils.areEqual((Throwable)t, (Object)t1));
        }
        Assert.assertFalse((boolean)ExceptUtils.areEqual((Throwable)t1, null));
        Assert.assertFalse((boolean)ExceptUtils.areEqual((Throwable)t1, (Object)NumberUtils.INTEGER_ZERO));
        Assert.assertEquals((long)ExceptUtils.getHashCode((Throwable)t1), (long)ExceptUtils.getHashCode((Throwable)t2));
    }

    @Before
    public void setupExceptUtilsTest() {
        ExceptUtilsTest.setLevel((String)TEST_CATEGORY, (Level)Level.WARN);
    }

    @Test
    public void interruptionEmptyNoThrow() throws Exception {
        ExceptUtils.checkInterruption();
    }

    @Test
    public void interruptionEmptyThrow() {
        Thread.currentThread().interrupt();
        try {
            ExceptUtils.checkInterruption();
            Assert.fail();
        }
        catch (InterruptedException ex) {
            Assert.assertTrue((boolean)Thread.interrupted());
            Assert.assertEquals((Object)"Thread execution was interrupted", (Object)ex.getMessage());
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    public void interruptionNestedNoThrow() throws Exception {
        ExceptUtils.checkInterruption((Throwable)new CloneNotSupportedException());
    }

    @Test
    public void interruptionNestedThrow() {
        CloneNotSupportedException nested = new CloneNotSupportedException();
        Thread.currentThread().interrupt();
        try {
            ExceptUtils.checkInterruption((Throwable)nested);
            Assert.fail();
        }
        catch (InterruptedException ex) {
            Assert.assertTrue((boolean)Thread.interrupted());
            Assert.assertEquals((Object)"Thread execution was interrupted", (Object)ex.getMessage());
            Assert.assertEquals((Object)nested, (Object)ex.getCause());
        }
    }

    @Test
    public void interruptionMessageNoThrow() throws Exception {
        ExceptUtils.checkInterruption((String)"Test message 1 (expected)");
    }

    @Test
    public void interruptionMessageThrow() {
        Thread.currentThread().interrupt();
        try {
            ExceptUtils.checkInterruption((String)"Test message 1 (expected)");
            Assert.fail();
        }
        catch (InterruptedException ex) {
            Assert.assertTrue((boolean)Thread.interrupted());
            Assert.assertEquals((Object)"Test message 1 (expected)", (Object)ex.getMessage());
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    public void interruptionMessageNestedNoThrow() throws Exception {
        ExceptUtils.checkInterruption((Throwable)new CloneNotSupportedException(), (String)"Test message 1 (expected)");
    }

    @Test
    public void interruptionMessageNestedThrow() {
        CloneNotSupportedException nested = new CloneNotSupportedException();
        Thread.currentThread().interrupt();
        try {
            ExceptUtils.checkInterruption((Throwable)nested, (String)"Test message 1 (expected)");
            Assert.fail();
        }
        catch (InterruptedException ex) {
            Assert.assertTrue((boolean)Thread.interrupted());
            Assert.assertEquals((Object)"Test message 1 (expected)", (Object)ex.getMessage());
            Assert.assertEquals((Object)nested, (Object)ex.getCause());
        }
    }

    @Test
    public void interruptException() {
        Assert.assertFalse((boolean)ExceptUtils.isInterruptException((Throwable)new CloneNotSupportedException()));
        Assert.assertTrue((boolean)ExceptUtils.isInterruptException((Throwable)new InterruptedException()));
        Assert.assertTrue((boolean)ExceptUtils.isInterruptException((Throwable)new InterruptedIOException()));
        Assert.assertTrue((boolean)ExceptUtils.isInterruptException((Throwable)new ClosedByInterruptException()));
        Assert.assertTrue((boolean)ExceptUtils.isInterruptException((Throwable)new FileLockInterruptionException()));
        Assert.assertTrue((boolean)ExceptUtils.isInterruptException((Throwable)new InterruptedNamingException()));
        Assert.assertTrue((boolean)ExceptUtils.isInterruptException((Throwable)new I18NInterruptedException()));
        Assert.assertTrue((boolean)ExceptUtils.isInterruptException((Throwable)new I18NInterruptedRuntimeException()));
    }

    @Test
    public void interrupt() {
        ExceptUtilsTest.interruptHelper(new CloneNotSupportedException(), false);
        ExceptUtilsTest.interruptHelper(new InterruptedException(), true);
        ExceptUtilsTest.interruptHelper(new InterruptedIOException(), true);
        ExceptUtilsTest.interruptHelper(new ClosedByInterruptException(), true);
        ExceptUtilsTest.interruptHelper(new FileLockInterruptionException(), true);
        ExceptUtilsTest.interruptHelper(new InterruptedNamingException(), true);
        ExceptUtilsTest.interruptHelper((Exception)new I18NInterruptedException(), true);
        ExceptUtilsTest.interruptHelper((Exception)new I18NInterruptedRuntimeException(), true);
    }

    @Test
    public void swallow() {
        this.swallowHelper(new CloneNotSupportedException(), false);
        this.swallowHelper(new InterruptedException(), true);
        this.swallowHelper(new InterruptedIOException(), true);
        this.swallowHelper(new ClosedByInterruptException(), true);
        this.swallowHelper(new FileLockInterruptionException(), true);
        this.swallowHelper(new InterruptedNamingException(), true);
        this.swallowHelper((Exception)new I18NInterruptedException(), true);
        this.swallowHelper((Exception)new I18NInterruptedRuntimeException(), true);
    }

    @Test
    public void wrap() {
        ExceptUtilsTest.wrapHelper(new CloneNotSupportedException(), false);
        ExceptUtilsTest.wrapHelper(new InterruptedException(), true);
        ExceptUtilsTest.wrapHelper(new InterruptedIOException(), true);
        ExceptUtilsTest.wrapHelper(new ClosedByInterruptException(), true);
        ExceptUtilsTest.wrapHelper(new FileLockInterruptionException(), true);
        ExceptUtilsTest.wrapHelper(new InterruptedNamingException(), true);
        ExceptUtilsTest.wrapHelper((Exception)new I18NInterruptedException(), true);
        ExceptUtilsTest.wrapHelper((Exception)new I18NInterruptedRuntimeException(), true);
    }

    @Test
    public void equality() {
        Assert.assertTrue((boolean)ExceptUtils.areEqual(null, null));
        ExceptUtilsTest.equalityHelper((Throwable)new ActivationException("Test message 1 (expected)"), (Throwable)new ActivationException("Test message 1 (expected)"), new Throwable[]{new ActivationException(), new ActivationException("Test message 2 (expected)"), new UnknownObjectException("Test message 1 (expected)"), new I18NException(), null});
        ExceptUtilsTest.equalityHelper((Throwable)new I18NException((Throwable)new ActivationException("Test message 1 (expected)"), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), (Throwable)new I18NException((Throwable)new ActivationException("Test message 1 (expected)"), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new Throwable[]{new I18NException((Throwable)new ActivationException("Test message 1 (expected)")), new I18NException((Throwable)new ActivationException("Test message 1 (expected)"), (I18NBoundMessage)TestMessages.BOT_EXCEPTION), new I18NException((Throwable)new ActivationException("Test message 2 (expected)"), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new ActivationException("Test message 1 (expected)"), null});
    }

    static {
        TEST_LOCATION = TEST_CATEGORY = ExceptUtils.class.getName();
    }
}

