/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import java.util.Locale;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessage2P;
import org.marketcetera.util.log.I18NMessageTestBase;
import org.marketcetera.util.log.TestMessages;

public class TI18NMessage2PTest
extends I18NMessageTestBase {
    private static final String TEST_MSG_EN = "P2 msg (expected) en 1 2";
    private static final String TEST_TTL_EN = "P2 ttl (expected) en 1 2";
    private static final String TEST_MSG_FR = "P2 msg (expected) fr 1 2";
    private static final String TEST_TTL_FR = "P2 ttl (expected) fr 1 2";
    private static final String TEST_LOCATION = TI18NMessage2PTest.class.getName();

    private static void castOverride(I18NMessage2P m) {
    }

    @Test
    public void basic() {
        TI18NMessage2PTest.unboundTests(2, (I18NMessage)new I18NMessage2P(TestMessages.LOGGER, "base", "ttl"), (I18NMessage)new I18NMessage2P(TestMessages.LOGGER, "base", "ttl"), new I18NMessage[]{new I18NMessage2P(TEST_LOGGER_D, "base", "ttl"), new I18NMessage2P(TestMessages.LOGGER, "baseD", "ttl"), new I18NMessage2P(TestMessages.LOGGER, "base", "ttlD"), new I18NMessage0P(TestMessages.LOGGER, "base", "ttl")}, (I18NMessage)new I18NMessage2P(TestMessages.LOGGER, "base"));
    }

    @Test
    public void messageProvider() {
        Assert.assertEquals((Object)TEST_MSG_EN, (Object)TestMessages.P2_MSG.getText((Object)"1", (Object)"2"));
        Assert.assertEquals((Object)TEST_TTL_EN, (Object)TestMessages.P2_TTL.getText((Object)"1", (Object)"2"));
        Assert.assertEquals((Object)TEST_MSG_FR, (Object)TestMessages.P2_MSG.getText(Locale.FRENCH, (Object)"1", (Object)"2"));
        Assert.assertEquals((Object)TEST_TTL_FR, (Object)TestMessages.P2_TTL.getText(Locale.FRENCH, (Object)"1", (Object)"2"));
    }

    @Test
    public void loggerProxy() {
        TestMessages.P2_MSG.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P2_MSG.error((Object)"TestCategory", (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P2_TTL.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P2_TTL.error((Object)"TestCategory", (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P2_MSG.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P2_MSG.warn((Object)"TestCategory", (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P2_TTL.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P2_TTL.warn((Object)"TestCategory", (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P2_MSG.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P2_MSG.info((Object)"TestCategory", (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P2_TTL.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P2_TTL.info((Object)"TestCategory", (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P2_MSG.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P2_MSG.debug((Object)"TestCategory", (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P2_TTL.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P2_TTL.debug((Object)"TestCategory", (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P2_MSG.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P2_MSG.trace((Object)"TestCategory", (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P2_TTL.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P2_TTL.trace((Object)"TestCategory", (Object)"1", (Object)"2");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
    }

    @Test
    public void bound() {
        Serializable[] params = new Serializable[]{"1", "2"};
        I18NBoundMessage2P m = new I18NBoundMessage2P(TestMessages.P2_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"));
        this.boundTests((I18NBoundMessage)m, (I18NBoundMessage)new I18NBoundMessage2P(TestMessages.P2_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2")), new I18NBoundMessage[]{new I18NBoundMessage2P(TestMessages.P2_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"1")), new I18NBoundMessage2P(TestMessages.P2_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2")), TestMessages.P0_MSG}, params, (I18NMessage)TestMessages.P2_MSG, TEST_MSG_EN, TEST_MSG_FR);
        TI18NMessage2PTest.castOverride((I18NMessage2P)m.getMessage());
        this.boundTests((I18NBoundMessage)new I18NBoundMessage2P(TestMessages.P2_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2")), (I18NBoundMessage)new I18NBoundMessage2P(TestMessages.P2_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2")), new I18NBoundMessage[]{new I18NBoundMessage2P(TestMessages.P2_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"1")), new I18NBoundMessage2P(TestMessages.P2_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2")), TestMessages.P0_TTL}, params, (I18NMessage)TestMessages.P2_TTL, TEST_TTL_EN, TEST_TTL_FR);
        Assert.assertEquals((Object)"1", (Object)m.getParam1());
        Assert.assertEquals((Object)"2", (Object)m.getParam2());
    }
}

