/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import java.util.Locale;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessage3P;
import org.marketcetera.util.log.I18NMessageTestBase;
import org.marketcetera.util.log.TestMessages;

public class TI18NMessage3PTest
extends I18NMessageTestBase {
    private static final String TEST_MSG_EN = "P3 msg (expected) en 1 2 3";
    private static final String TEST_TTL_EN = "P3 ttl (expected) en 1 2 3";
    private static final String TEST_MSG_FR = "P3 msg (expected) fr 1 2 3";
    private static final String TEST_TTL_FR = "P3 ttl (expected) fr 1 2 3";
    private static final String TEST_LOCATION = TI18NMessage3PTest.class.getName();

    private static void castOverride(I18NMessage3P m) {
    }

    @Test
    public void basic() {
        TI18NMessage3PTest.unboundTests(3, (I18NMessage)new I18NMessage3P(TestMessages.LOGGER, "base", "ttl"), (I18NMessage)new I18NMessage3P(TestMessages.LOGGER, "base", "ttl"), new I18NMessage[]{new I18NMessage3P(TEST_LOGGER_D, "base", "ttl"), new I18NMessage3P(TestMessages.LOGGER, "baseD", "ttl"), new I18NMessage3P(TestMessages.LOGGER, "base", "ttlD"), new I18NMessage0P(TestMessages.LOGGER, "base", "ttl")}, (I18NMessage)new I18NMessage3P(TestMessages.LOGGER, "base"));
    }

    @Test
    public void messageProvider() {
        Assert.assertEquals((Object)TEST_MSG_EN, (Object)TestMessages.P3_MSG.getText((Object)"1", (Object)"2", (Object)"3"));
        Assert.assertEquals((Object)TEST_TTL_EN, (Object)TestMessages.P3_TTL.getText((Object)"1", (Object)"2", (Object)"3"));
        Assert.assertEquals((Object)TEST_MSG_FR, (Object)TestMessages.P3_MSG.getText(Locale.FRENCH, (Object)"1", (Object)"2", (Object)"3"));
        Assert.assertEquals((Object)TEST_TTL_FR, (Object)TestMessages.P3_TTL.getText(Locale.FRENCH, (Object)"1", (Object)"2", (Object)"3"));
    }

    @Test
    public void loggerProxy() {
        TestMessages.P3_MSG.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P3_MSG.error((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P3_TTL.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P3_TTL.error((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P3_MSG.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P3_MSG.warn((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P3_TTL.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P3_TTL.warn((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P3_MSG.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P3_MSG.info((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P3_TTL.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P3_TTL.info((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P3_MSG.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P3_MSG.debug((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P3_TTL.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P3_TTL.debug((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P3_MSG.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P3_MSG.trace((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P3_TTL.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P3_TTL.trace((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
    }

    @Test
    public void bound() {
        Serializable[] params = new Serializable[]{"1", "2", "3"};
        I18NBoundMessage3P m = new I18NBoundMessage3P(TestMessages.P3_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"));
        this.boundTests((I18NBoundMessage)m, (I18NBoundMessage)new I18NBoundMessage3P(TestMessages.P3_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3")), new I18NBoundMessage[]{new I18NBoundMessage3P(TestMessages.P3_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"1")), new I18NBoundMessage3P(TestMessages.P3_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3")), TestMessages.P0_MSG}, params, (I18NMessage)TestMessages.P3_MSG, TEST_MSG_EN, TEST_MSG_FR);
        TI18NMessage3PTest.castOverride((I18NMessage3P)m.getMessage());
        this.boundTests((I18NBoundMessage)new I18NBoundMessage3P(TestMessages.P3_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3")), (I18NBoundMessage)new I18NBoundMessage3P(TestMessages.P3_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3")), new I18NBoundMessage[]{new I18NBoundMessage3P(TestMessages.P3_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"1")), new I18NBoundMessage3P(TestMessages.P3_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3")), TestMessages.P0_TTL}, params, (I18NMessage)TestMessages.P3_TTL, TEST_TTL_EN, TEST_TTL_FR);
        Assert.assertEquals((Object)"1", (Object)m.getParam1());
        Assert.assertEquals((Object)"2", (Object)m.getParam2());
        Assert.assertEquals((Object)"3", (Object)m.getParam3());
    }
}

