/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.test.UnicodeData;
import org.marketcetera.util.unicode.Messages;
import org.marketcetera.util.unicode.Serialization;
import org.marketcetera.util.unicode.Signature;
import org.marketcetera.util.unicode.SignatureCharset;

public class SerializationTest
extends TestCaseBase {
    private static final Serialization[] NO_SERIALIZATIONS = new Serialization[0];

    private static void common(Serialization serialization, byte[] data, SignatureCharset sc) throws Exception {
        data = ArrayUtils.addAll((byte[])sc.getSignature().getMark(), (byte[])data);
        Serialization[] candidates = new Serialization[]{serialization};
        Assert.assertEquals((Object)sc, (Object)Serialization.getPrefixMatch((Serialization[])candidates, (byte[])data));
        Assert.assertEquals((Object)"Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", (Object)Serialization.decode((Serialization[])candidates, (byte[])data));
    }

    private static void single(Serialization serialization, int count, byte[] data, SignatureCharset sc) throws Exception {
        Serialization[] candidates = new Serialization[]{serialization};
        Assert.assertNotNull((Object)serialization.getSignatureCharsets());
        Assert.assertEquals((long)count, (long)serialization.getSignatureCharsets().length);
        Assert.assertNull((Object)Serialization.decode((Serialization[])candidates, null));
        SerializationTest.common(serialization, data, sc);
        Assert.assertEquals((Object)(sc.getSignature() == Signature.NONE ? sc : null), (Object)Serialization.getPrefixMatch((Serialization[])candidates, (byte[])new byte[]{1}));
    }

    private static void multi(Serialization serialization, byte[] data1, SignatureCharset sc1, byte[] data2, SignatureCharset sc2, byte[] data3, SignatureCharset sc3) throws Exception {
        Serialization[] candidates = new Serialization[]{serialization};
        Assert.assertNotNull((Object)serialization.getSignatureCharsets());
        Assert.assertEquals((long)3L, (long)serialization.getSignatureCharsets().length);
        Assert.assertNull((Object)Serialization.decode((Serialization[])candidates, null));
        SerializationTest.common(serialization, data1, sc1);
        SerializationTest.common(serialization, data2, sc2);
        SerializationTest.common(serialization, data3, sc3);
        Assert.assertEquals((Object)serialization.getSignatureCharsets()[0], (Object)Serialization.getPrefixMatch((Serialization[])candidates, (byte[])new byte[]{1}));
    }

    @Test
    public void all() throws Exception {
        SerializationTest.single(Serialization.UTF8, 1, UnicodeData.COMBO_UTF8, SignatureCharset.UTF8_UTF8);
        SerializationTest.single(Serialization.UTF8N, 1, UnicodeData.COMBO_UTF8, SignatureCharset.NONE_UTF8);
        SerializationTest.single(Serialization.UTF16BE, 1, UnicodeData.COMBO_UTF16BE, SignatureCharset.NONE_UTF16BE);
        SerializationTest.single(Serialization.UTF16LE, 1, UnicodeData.COMBO_UTF16LE, SignatureCharset.NONE_UTF16LE);
        SerializationTest.single(Serialization.UTF32BE, 1, UnicodeData.COMBO_UTF32BE, SignatureCharset.NONE_UTF32BE);
        SerializationTest.single(Serialization.UTF32LE, 1, UnicodeData.COMBO_UTF32LE, SignatureCharset.NONE_UTF32LE);
        SerializationTest.single(Serialization.UTF16BE_REQ, 1, UnicodeData.COMBO_UTF16BE, SignatureCharset.UTF16BE_UTF16BE);
        SerializationTest.single(Serialization.UTF16LE_REQ, 1, UnicodeData.COMBO_UTF16LE, SignatureCharset.UTF16LE_UTF16LE);
        SerializationTest.single(Serialization.UTF32BE_REQ, 1, UnicodeData.COMBO_UTF32BE, SignatureCharset.UTF32BE_UTF32BE);
        SerializationTest.single(Serialization.UTF32LE_REQ, 1, UnicodeData.COMBO_UTF32LE, SignatureCharset.UTF32LE_UTF32LE);
        SerializationTest.multi(Serialization.UTF16, UnicodeData.COMBO_UTF16BE, SignatureCharset.NONE_UTF16BE, UnicodeData.COMBO_UTF16BE, SignatureCharset.UTF16BE_UTF16BE, UnicodeData.COMBO_UTF16LE, SignatureCharset.UTF16LE_UTF16LE);
        SerializationTest.multi(Serialization.UTF32, UnicodeData.COMBO_UTF32BE, SignatureCharset.NONE_UTF32BE, UnicodeData.COMBO_UTF32BE, SignatureCharset.UTF32BE_UTF32BE, UnicodeData.COMBO_UTF32LE, SignatureCharset.UTF32LE_UTF32LE);
    }

    @Test
    public void multiMatch() throws Exception {
        byte[] data = new byte[]{1};
        Assert.assertNull((Object)Serialization.getPrefixMatch((Serialization[])NO_SERIALIZATIONS, (byte[])data));
        try {
            Serialization.decode((Serialization[])NO_SERIALIZATIONS, (byte[])data);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)Messages.NO_SIGNATURE_MATCHES, (Object)ex.getI18NBoundMessage());
        }
        Assert.assertEquals((Object)SignatureCharset.NONE_UTF16BE, (Object)Serialization.getPrefixMatch((Serialization[])new Serialization[]{Serialization.UTF16, Serialization.UTF32}, (byte[])data));
        Assert.assertEquals((Object)SignatureCharset.NONE_UTF32BE, (Object)Serialization.getPrefixMatch((Serialization[])new Serialization[]{Serialization.UTF32, Serialization.UTF16}, (byte[])data));
        Assert.assertEquals((Object)SignatureCharset.UTF32LE_UTF32LE, (Object)Serialization.getPrefixMatch((Serialization[])new Serialization[]{Serialization.UTF16, Serialization.UTF32}, (byte[])Signature.UTF32LE.getMark()));
        Assert.assertEquals((Object)SignatureCharset.UTF32LE_UTF32LE, (Object)Serialization.getPrefixMatch((Serialization[])new Serialization[]{Serialization.UTF32, Serialization.UTF16}, (byte[])Signature.UTF32LE.getMark()));
    }
}

