/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import javax.xml.ws.WebServiceException;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.Client;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateful.FixedAuthenticator;
import org.marketcetera.util.ws.stateful.Messages;
import org.marketcetera.util.ws.stateful.Server;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.ClientServerTestBase;
import org.marketcetera.util.ws.stateless.StatelessClient;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.stateless.StatelessServer;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.wrappers.RemoteException;

public class ClientServerTest
extends ClientServerTestBase {
    private static final Authenticator TEST_AUTHENTICATOR = new FixedAuthenticator();
    private static final SessionManager<Object> TEST_MANAGER = new SessionManager();
    private static final String TEST_USER = "metc";
    private static final String TEST_USER_D = "metcD";
    private static final char[] TEST_PASSWORD = "metc".toCharArray();

    private static StatelessClientContext getStatelessContext(Client client) {
        ClientContext context = client.getContext();
        StatelessClientContext statelessContext = new StatelessClientContext();
        statelessContext.setVersionId(context.getVersionId());
        statelessContext.setAppId(context.getAppId());
        statelessContext.setClientId(context.getClientId());
        statelessContext.setLocale(context.getLocale());
        return statelessContext;
    }

    private static <T> void calls(Server<T> server, Client client) {
        Client client2 = new Client(client.getHost(), client.getPort() + 1, client.getAppId());
        ClientServerTest.calls(server, (StatelessClient)client, ClientServerTest.getStatelessContext(client).toString(), (StatelessServer)new Server(client2.getHost(), client2.getPort(), server.getAuthenticator(), server.getSessionManager()), (StatelessClient)client2, ClientServerTest.getStatelessContext(client2).toString());
    }

    protected static void singleServer(Server<?> server, Server<?> empty) {
        ClientServerTest.singleServer(server, empty);
        Assert.assertNull((Object)server.getAuthenticator());
        Assert.assertEquals(TEST_MANAGER, (Object)server.getSessionManager());
        Assert.assertNull((Object)empty.getAuthenticator());
        Assert.assertNull((Object)empty.getSessionManager());
    }

    @Test
    public void basics() {
        ClientServerTest.singleClientEmpty((StatelessClient)new Client("testHost", 1, TEST_APP), (StatelessClient)new Client());
        ClientServerTest.singleClientJustId((StatelessClient)new Client("testHost", 1, TEST_APP), (StatelessClient)new Client(TEST_APP));
        ClientServerTest.singleServer(new Server("testHost", 1, null, TEST_MANAGER), new Server());
        ClientServerTest.calls(new Server(), new Client());
        ClientServerTest.calls(new Server(), new Client(TEST_APP));
        ClientServerTest.badConnection((StatelessServer)new Server("testHost", -1, null, TEST_MANAGER), (StatelessClient)new Client("testHost", -1, TEST_APP));
    }

    @Test
    public void session() throws Exception {
        Client c = new Client();
        Server s = new Server(TEST_AUTHENTICATOR, TEST_MANAGER);
        Assert.assertEquals((Object)TEST_AUTHENTICATOR, (Object)s.getAuthenticator());
        try {
            c.assertValidSession();
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((Object)Messages.NOT_LOGGED_IN, (Object)ex.getI18NBoundMessage());
        }
        c.login(TEST_USER, TEST_PASSWORD);
        SessionId id = c.getSessionId();
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((Object)id, (Object)c.getContext().getSessionId());
        Assert.assertEquals((Object)TEST_USER, (Object)TEST_MANAGER.get(id).getUser());
        try {
            c.login(TEST_USER, TEST_PASSWORD);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((Object)Messages.ALREADY_LOGGED_IN, (Object)ex.getI18NBoundMessage());
        }
        Assert.assertEquals((Object)id, (Object)c.getSessionId());
        Assert.assertEquals((Object)TEST_USER, (Object)TEST_MANAGER.get(id).getUser());
        c.logout();
        Assert.assertNull((Object)c.getSessionId());
        Assert.assertNull((Object)c.getContext().getSessionId());
        Assert.assertNull((Object)TEST_MANAGER.get(id));
        try {
            c.login(TEST_USER_D, TEST_PASSWORD);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertEquals((Object)Messages.BAD_CREDENTIALS, (Object)((I18NException)ex.getCause()).getI18NBoundMessage());
        }
        Assert.assertNull((Object)c.getSessionId());
        c.logout();
        s.stop();
        try {
            c.login(TEST_USER, TEST_PASSWORD);
            Assert.fail();
        }
        catch (WebServiceException ex) {
            // empty catch block
        }
    }
}

