/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.tags;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.tags.Messages;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.tags.Tag;
import org.marketcetera.util.ws.tags.TagFilter;
import org.marketcetera.util.ws.tags.TagFilterTestBase;
import org.marketcetera.util.ws.tags.ValidSessionTagFilter;

public class ValidSessionTagFilterTest
extends TagFilterTestBase {
    private static final String TEST_USER = "metc";
    private static final StatelessClientContext TEST_CONTEXT = new StatelessClientContext();

    @Test
    public void all() throws Exception {
        SessionId sessionId = new SessionId();
        sessionId.setValue(TEST_TAG.getValue());
        SessionManager sessionManager = new SessionManager();
        sessionManager.put(sessionId, new SessionHolder(TEST_USER, TEST_CONTEXT));
        ValidSessionTagFilter filter = new ValidSessionTagFilter(sessionManager);
        Assert.assertEquals((Object)sessionManager, (Object)filter.getSessionManager());
        ValidSessionTagFilterTest.single((TagFilter)filter, (Tag)sessionId, null, (I18NBoundMessage)Messages.SESSION_REQUIRED);
        ValidSessionTagFilterTest.single((TagFilter)filter, (Tag)sessionId, TEST_TAG, (I18NBoundMessage)new I18NBoundMessage1P(Messages.SESSION_EXPIRED, (Serializable)TEST_TAG));
        ValidSessionTagFilterTest.single((TagFilter)filter, (Tag)sessionId, TEST_TAG_D, (I18NBoundMessage)new I18NBoundMessage1P(Messages.SESSION_EXPIRED, (Serializable)TEST_TAG_D));
        SessionId sessionIdD = new SessionId();
        sessionIdD.setValue(TEST_TAG_D.getValue());
        ValidSessionTagFilterTest.single((TagFilter)filter, (Tag)sessionId, (Tag)sessionIdD, (I18NBoundMessage)new I18NBoundMessage1P(Messages.SESSION_EXPIRED, (Serializable)sessionIdD));
        filter = new ValidSessionTagFilter(null);
        Assert.assertNull((Object)filter.getSessionManager());
        ValidSessionTagFilterTest.singlePass((TagFilter)filter, (Tag)sessionId);
        ValidSessionTagFilterTest.singlePass((TagFilter)filter, null);
        ValidSessionTagFilterTest.singlePass((TagFilter)filter, TEST_TAG);
    }
}

