/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.test.EqualityAssert;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.wrappers.RemoteProxyException;

public class RemoteProxyExceptionTest
extends TestCaseBase {
    private static final String TEST_MESSAGE = "testMessage";
    private static final String[] TEST_TRACE = new String[]{"testTrace"};
    private static final String TEST_TRACE_PRINT = "testTrace" + SystemUtils.LINE_SEPARATOR;
    private static final String TEST_STRING = "testString";
    private static final String TEST_CLASS = "testClass";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStackTraceNoArg(RemoteProxyException ex) {
        PrintStream stdErrSave = System.err;
        CloseableRegistry r = new CloseableRegistry();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        try {
            r.register((Closeable)byteArray);
            PrintStream stdErr = new PrintStream(byteArray);
            r.register((Closeable)stdErr);
            System.setErr(stdErr);
            ex.printStackTrace();
        }
        finally {
            System.setErr(stdErrSave);
            r.close();
        }
        return new String(byteArray.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStackTraceStream(RemoteProxyException ex) {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        try (CloseableRegistry r = new CloseableRegistry();){
            r.register((Closeable)byteArray);
            PrintStream out = new PrintStream(byteArray);
            r.register((Closeable)out);
            ex.printStackTrace(out);
        }
        return new String(byteArray.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStackTraceWriter(RemoteProxyException ex) {
        StringWriter string = new StringWriter();
        try (CloseableRegistry r = new CloseableRegistry();){
            r.register((Closeable)string);
            PrintWriter out = new PrintWriter(string);
            r.register((Closeable)out);
            ex.printStackTrace(out);
        }
        return string.toString();
    }

    @Test
    public void basics() {
        EqualityAssert.assertEquality((Object)new RemoteProxyException(TEST_MESSAGE, TEST_TRACE, TEST_STRING, TEST_CLASS), (Object)new RemoteProxyException(TEST_MESSAGE, TEST_TRACE, TEST_STRING, TEST_CLASS), (Object[])new Object[]{new RemoteProxyException(null, TEST_TRACE, TEST_STRING, TEST_CLASS), new RemoteProxyException(TEST_MESSAGE, null, TEST_STRING, TEST_CLASS), new RemoteProxyException(TEST_MESSAGE, TEST_TRACE, null, TEST_CLASS), new RemoteProxyException(TEST_MESSAGE, TEST_TRACE, TEST_STRING, null), new RemoteProxyException("testMessaged", TEST_TRACE, TEST_STRING, TEST_CLASS), new RemoteProxyException(TEST_MESSAGE, new String[]{"d"}, TEST_STRING, TEST_CLASS), new RemoteProxyException(TEST_MESSAGE, TEST_TRACE, "testStringd", TEST_CLASS), new RemoteProxyException(TEST_MESSAGE, TEST_TRACE, TEST_STRING, "testClassd")});
        RemoteProxyException ex = new RemoteProxyException(TEST_MESSAGE, TEST_TRACE, TEST_STRING, TEST_CLASS);
        Assert.assertEquals((Object)TEST_MESSAGE, (Object)ex.getMessage());
        Assert.assertArrayEquals((Object[])TEST_TRACE, (Object[])ex.getTraceCapture());
        Assert.assertEquals((Object)TEST_TRACE_PRINT, (Object)RemoteProxyExceptionTest.getStackTraceNoArg(ex));
        Assert.assertEquals((Object)TEST_TRACE_PRINT, (Object)RemoteProxyExceptionTest.getStackTraceStream(ex));
        Assert.assertEquals((Object)TEST_TRACE_PRINT, (Object)RemoteProxyExceptionTest.getStackTraceWriter(ex));
        Assert.assertNull((Object)ex.getStackTrace());
        Assert.assertEquals((Object)TEST_STRING, (Object)ex.toString());
        Assert.assertEquals((Object)TEST_CLASS, (Object)ex.getServerName());
    }

    @Test
    public void nullParams() {
        EqualityAssert.assertEquality((Object)new RemoteProxyException(null, null, null, null), (Object)new RemoteProxyException(null, null, null, null), (Object[])new Object[]{new RemoteProxyException(TEST_MESSAGE, TEST_TRACE, TEST_STRING, TEST_CLASS)});
        RemoteProxyException ex = new RemoteProxyException(null, null, null, null);
        Assert.assertNull((Object)ex.getMessage());
        Assert.assertNull((Object)ex.getTraceCapture());
        Assert.assertEquals((Object)"", (Object)RemoteProxyExceptionTest.getStackTraceNoArg(ex));
        Assert.assertEquals((Object)"", (Object)RemoteProxyExceptionTest.getStackTraceStream(ex));
        Assert.assertEquals((Object)"", (Object)RemoteProxyExceptionTest.getStackTraceWriter(ex));
        Assert.assertNull((Object)ex.getStackTrace());
        Assert.assertNull((Object)ex.toString());
        Assert.assertNull((Object)ex.getServerName());
    }
}

