/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.except.I18NThrowable;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage0P;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NLoggerProxy;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessageProvider;
import org.marketcetera.util.test.EqualityAssert;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.wrappers.BaseWrapper;
import org.marketcetera.util.ws.wrappers.DualWrapper;
import org.marketcetera.util.ws.wrappers.RemoteProxyException;
import org.marketcetera.util.ws.wrappers.RootElementWrapper;
import org.marketcetera.util.ws.wrappers.SerWrapper;
import org.marketcetera.util.ws.wrappers.TestMessages;

public class WrapperTestBase
extends TestCaseBase {
    protected static final String TEST_VALUE = "testValue";
    protected static final String TEST_VALUE_D = "testValueD";
    protected static final String TEST_MESSAGE = "testMessage";
    protected static final I18NBoundMessage1P TEST_I18N_MESSAGE = new I18NBoundMessage1P(TestMessages.BOUND, (Serializable)((Object)"testMessage"));
    protected static final I18NBoundMessage1P TEST_NONSER_MESSAGE = new I18NBoundMessage1P(TestMessages.BOUND, (Serializable)new TestUnserializableInteger(1));
    protected static final I18NBoundMessage0P TEST_NONDESER_MESSAGE = new I18NBoundMessage0P(new I18NMessage0P(new I18NLoggerProxy(new I18NMessageProvider("nonexistent_prv")), "any"));
    protected static final Throwable TEST_THROWABLE = new TestThrowable("testMessage");
    protected static final I18NException TEST_I18N_THROWABLE = new I18NException(TEST_THROWABLE, (I18NBoundMessage)TEST_I18N_MESSAGE);
    protected static final Throwable TEST_NONSER_THROWABLE = new TestUnserializableThrowable("testMessage");
    protected static final I18NException TEST_NONDESER_THROWABLE = new I18NException(TEST_THROWABLE, (I18NBoundMessage)TEST_NONDESER_MESSAGE);

    @Before
    public void setupWrapperTestBase() {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
        WrapperTestBase.setDefaultLevel((Level)Level.OFF);
    }

    protected static <T> T roundTripJAXB(T object) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RootElementWrapper.class, object.getClass()});
        StringWriter writer = new StringWriter();
        context.createMarshaller().marshal((Object)new RootElementWrapper(object), (Writer)writer);
        return (T)((RootElementWrapper)context.createUnmarshaller().unmarshal((Reader)new StringReader(writer.toString()))).getObject();
    }

    protected static <T extends Serializable> T roundTripJava(T object) {
        return (T)((Serializable)SerializationUtils.deserialize((byte[])SerializationUtils.serialize(object)));
    }

    protected static <T> void single(BaseWrapper<T> wrapper, BaseWrapper<T> copy, BaseWrapper<T> empty, BaseWrapper<T> nullArg, String stringValue) throws Exception {
        EqualityAssert.assertEquality(wrapper, copy, (Object[])new Object[]{empty, nullArg});
        EqualityAssert.assertEquality(empty, nullArg, (Object[])new Object[]{wrapper, copy});
        Assert.assertEquals((Object)stringValue, (Object)wrapper.toString());
        Assert.assertNull((Object)empty.getValue());
        Assert.assertNull((Object)nullArg.getValue());
        Assert.assertEquals(wrapper, WrapperTestBase.roundTripJAXB(wrapper));
    }

    protected static <R, M> void dual(DualWrapper<R, M> wrapper, DualWrapper<R, M> copy, DualWrapper<R, M> empty, DualWrapper<R, M> nullArg, String stringValue, R rawValue, M marshalledValue) throws Exception {
        WrapperTestBase.single(wrapper, copy, empty, nullArg, stringValue);
        Assert.assertEquals(wrapper, WrapperTestBase.roundTripJava(wrapper));
        Assert.assertNull((Object)empty.getRaw());
        Assert.assertNull((Object)empty.getMarshalled());
        Assert.assertNull((Object)nullArg.getRaw());
        Assert.assertNull((Object)nullArg.getMarshalled());
        wrapper.setMarshalled(null);
        Assert.assertNull((Object)wrapper.getRaw());
        Assert.assertNull((Object)wrapper.getMarshalled());
        Assert.assertEquals(wrapper, empty);
        wrapper.setMarshalled(marshalledValue);
        Assert.assertTrue((boolean)ArrayUtils.isEquals(rawValue, (Object)wrapper.getRaw()));
        Assert.assertTrue((boolean)ArrayUtils.isEquals(marshalledValue, (Object)wrapper.getMarshalled()));
        wrapper.setRaw(null);
        Assert.assertNull((Object)wrapper.getRaw());
        Assert.assertNull((Object)wrapper.getMarshalled());
        Assert.assertEquals(wrapper, empty);
        wrapper.setRaw(rawValue);
        Assert.assertTrue((boolean)ArrayUtils.isEquals(rawValue, (Object)wrapper.getRaw()));
        Assert.assertTrue((boolean)ArrayUtils.isEquals(marshalledValue, (Object)wrapper.getMarshalled()));
    }

    protected void prepareSerWrapperFailure(String category) {
        WrapperTestBase.setLevel((String)category, (Level)Level.WARN);
        this.getAppender().clear();
    }

    protected void prepareSerWrapperFailure() {
        this.prepareSerWrapperFailure(SerWrapper.class.getName());
    }

    protected void assertSerWrapperDeSerFailure(SerWrapper<?> wrapper, String category) {
        Assert.assertNotNull((Object)((Object)wrapper.getDeserializationException()));
        this.assertSomeEvent(Level.WARN, category, "A deserialization error has occured; the object will be assumed to have a null value", SerWrapper.class.getName());
        Assert.assertNull((Object)wrapper.getRaw());
        Assert.assertNull((Object)wrapper.getMarshalled());
    }

    protected void assertSerWrapperDeSerFailure(SerWrapper<?> wrapper) {
        this.assertSerWrapperDeSerFailure(wrapper, SerWrapper.class.getName());
    }

    protected void assertSerWrapperSerFailure(SerWrapper<?> wrapper, String category) {
        Assert.assertNotNull((Object)((Object)wrapper.getSerializationException()));
        this.assertSomeEvent(Level.WARN, category, "A serialization error has occured; the object will be assumed to have a null value", SerWrapper.class.getName());
        Assert.assertNull((Object)wrapper.getRaw());
        Assert.assertNull((Object)wrapper.getMarshalled());
    }

    protected void assertSerWrapperSerFailure(SerWrapper<?> wrapper) {
        this.assertSerWrapperSerFailure(wrapper, SerWrapper.class.getName());
    }

    protected <T extends Serializable> void serialization(SerWrapper<T> wrapper, SerWrapper<T> copy, SerWrapper<T> empty, SerWrapper<T> nullArg, String stringValue, T value, T unserializableValue, String category) throws Exception {
        WrapperTestBase.dual(wrapper, copy, empty, nullArg, stringValue, value, SerializationUtils.serialize(value));
        Assert.assertNull((Object)((Object)wrapper.getSerializationException()));
        Assert.assertNull((Object)((Object)wrapper.getDeserializationException()));
        this.prepareSerWrapperFailure(category);
        wrapper.setRaw(unserializableValue);
        this.assertSerWrapperSerFailure(wrapper, category);
        this.prepareSerWrapperFailure(category);
        wrapper.setMarshalled((Object)ArrayUtils.EMPTY_BYTE_ARRAY);
        this.assertSerWrapperDeSerFailure(wrapper, category);
    }

    protected <T> T assertRoundTripJAXB(T object) throws Exception {
        this.prepareSerWrapperFailure();
        T result = WrapperTestBase.roundTripJAXB(object);
        Assert.assertEquals(object, result);
        return result;
    }

    protected <T extends Serializable> T assertRoundTripJava(T object) {
        this.prepareSerWrapperFailure();
        T result = WrapperTestBase.roundTripJava(object);
        Assert.assertEquals(object, result);
        return result;
    }

    protected static void assertThrowable(Throwable expected, Throwable actual, boolean proxyUsed) {
        if (actual == null || expected == null) {
            Assert.assertEquals((Object)expected, (Object)actual);
            return;
        }
        if (proxyUsed) {
            Assert.assertEquals(RemoteProxyException.class, actual.getClass());
            if (expected instanceof I18NThrowable) {
                Assert.assertEquals((Object)((I18NThrowable)expected).getLocalizedDetail(), (Object)actual.getMessage());
                ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
                Assert.assertEquals((Object)((I18NThrowable)expected).getLocalizedDetail(), (Object)actual.getMessage());
                ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
            } else {
                Assert.assertEquals((Object)expected.getLocalizedMessage(), (Object)actual.getMessage());
            }
        } else {
            Assert.assertEquals(expected.getClass(), actual.getClass());
            Assert.assertEquals((Object)expected.getMessage(), (Object)actual.getMessage());
        }
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        Assert.assertArrayEquals((Object[])ExceptionUtils.getStackFrames((Throwable)expected), (Object[])ExceptionUtils.getStackFrames((Throwable)actual));
    }

    protected static class TestUnserializableThrowable
    extends Throwable {
        private static final long serialVersionUID = 1L;

        public TestUnserializableThrowable(String message) {
            super(message);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException();
        }
    }

    protected static class TestThrowable
    extends Throwable {
        private static final long serialVersionUID = 1L;

        public TestThrowable(String message) {
            super(message);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !this.getClass().equals(other.getClass())) {
                return false;
            }
            return ObjectUtils.equals((Object)this.toString(), (Object)other.toString());
        }
    }

    protected static class TestUnserializableInteger
    extends TestInteger {
        private static final long serialVersionUID = 1L;

        public TestUnserializableInteger(int value) {
            super(value);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException();
        }
    }

    protected static class TestInteger
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int mValue;

        public TestInteger(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public String toString() {
            return "I am " + this.getValue();
        }

        public int hashCode() {
            return this.getValue();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !this.getClass().equals(other.getClass())) {
                return false;
            }
            TestInteger o = (TestInteger)other;
            return this.getValue() == o.getValue();
        }
    }
}

