/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.except;

import org.marketcetera.util.except.I18NThrowable;
import org.marketcetera.util.except.Messages;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: I18NExceptUtils.java 16154 2012-07-14 16:34:05Z colin $")
final class I18NExceptUtils {
    static String getLocalizedMessage(I18NThrowable t) {
        if (t.getI18NBoundMessage() == null) {
            return t.getMessage();
        }
        return t.getI18NBoundMessage().getText();
    }

    static String getDetail(I18NThrowable t) {
        String selfMessage = null;
        if (t.getI18NBoundMessage() != null) {
            selfMessage = t.getMessage();
        }
        String causeMessage = null;
        Throwable cause = t.getCause();
        if (cause != null) {
            causeMessage = cause instanceof I18NThrowable ? ((I18NThrowable)((Object)cause)).getDetail() : cause.getMessage();
        }
        if (selfMessage != null && causeMessage != null) {
            return selfMessage + " (" + causeMessage + ")";
        }
        if (selfMessage != null) {
            return selfMessage;
        }
        return causeMessage;
    }

    static String getLocalizedDetail(I18NThrowable t) {
        String selfMessage = null;
        if (t.getI18NBoundMessage() != null) {
            selfMessage = t.getLocalizedMessage();
        }
        String causeMessage = null;
        Throwable cause = t.getCause();
        if (cause != null) {
            causeMessage = cause instanceof I18NThrowable ? ((I18NThrowable)((Object)cause)).getLocalizedDetail() : cause.getLocalizedMessage();
        }
        if (selfMessage != null && causeMessage != null) {
            return Messages.COMBINE_MESSAGES.getText(selfMessage, causeMessage);
        }
        if (selfMessage != null) {
            return selfMessage;
        }
        return causeMessage;
    }

    private I18NExceptUtils() {
    }
}

