/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import org.apache.commons.lang.SystemUtils;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: OperatingSystem.java 16154 2012-07-14 16:34:05Z colin $")
public enum OperatingSystem {
    WINDOWS_2000("Windows 2000"),
    WINDOWS_2003("Windows 2003"),
    WINDOWS_CE("Windows CE"),
    WINDOWS_XP("Windows XP"),
    WINDOWS_VISTA("Windows Vista"),
    WINDOWS_7("Windows 7"),
    MAC_OS_X("Mac OS X"),
    DARWIN("Darwin"),
    FREEBSD("FreeBSD"),
    LINUX("Linux"),
    SOLARIS("SunOS"),
    AIX("AIX"),
    HPUX("HP-UX"),
    UNKNOWN(null);

    public static final String LABEL_WIN32 = "win32";
    public static final String LABEL_UNIX = "unix";
    public static final OperatingSystem LOCAL;
    private final String mJavaName;

    private OperatingSystem(String javaName) {
        this.mJavaName = javaName;
    }

    public static OperatingSystem get(String javaName) {
        for (OperatingSystem os : OperatingSystem.values()) {
            String enumName = os.getJavaName();
            if (enumName == null || !enumName.equals(javaName)) continue;
            return os;
        }
        return UNKNOWN;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        if (this.getJavaName() != null) {
            builder.append(',');
            builder.append(this.getJavaName());
        }
        if (this.isWin32()) {
            builder.append(',');
            builder.append(LABEL_WIN32);
        }
        if (this.isUnix()) {
            builder.append(',');
            builder.append(LABEL_UNIX);
        }
        return builder.toString();
    }

    public String getJavaName() {
        return this.mJavaName;
    }

    public boolean isWin32() {
        return this == WINDOWS_2000 || this == WINDOWS_2003 || this == WINDOWS_CE || this == WINDOWS_XP || this == WINDOWS_VISTA || this == WINDOWS_7;
    }

    public boolean isUnix() {
        return this == DARWIN || this == MAC_OS_X || this == FREEBSD || this == LINUX || this == SOLARIS || this == AIX || this == HPUX;
    }

    static {
        LOCAL = OperatingSystem.get(SystemUtils.OS_NAME);
    }
}

