/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.collections;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.collections.UnmodifiableDeque;
import org.marketcetera.util.test.CollectionAssert;

public class UnmodifiableDequeTest {
    @Test
    public void constructorTest() throws Exception {
        try {
            new UnmodifiableDeque(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        LinkedList<String> testCollection = new LinkedList<String>();
        UnmodifiableDeque q = new UnmodifiableDeque(testCollection);
        Assert.assertTrue((boolean)q.isEmpty());
        Assert.assertEquals((long)0L, (long)q.size());
        testCollection.add("value");
        Assert.assertEquals((long)1L, (long)q.size());
    }

    @Test
    public void unsupportedOperations() throws Exception {
        LinkedList testCollection = new LinkedList();
        UnmodifiableDeque q = new UnmodifiableDeque(testCollection);
        try {
            q.addAll(testCollection);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.clear();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.removeAll(testCollection);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.retainAll(testCollection);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.add("new value");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.addFirst("new value");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.addLast("new value");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.offer("new value");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.offerFirst("new value");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.offerLast("new value");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.poll();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.pollFirst();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.pollLast();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.pop();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.push("new value again");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.remove("new value again");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.removeFirst();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.removeFirstOccurrence("new value again");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.removeLast();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            q.removeLastOccurrence("new value again");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void supportedOperations() throws Exception {
        LinkedList<String> testCollection = new LinkedList<String>();
        UnmodifiableDeque q = new UnmodifiableDeque(testCollection);
        LinkedList<String> expectedCollection = new LinkedList<String>();
        this.verify(expectedCollection, (Deque<String>)q);
        String value1 = "value-" + System.nanoTime();
        testCollection.add(value1);
        expectedCollection.add(value1);
        this.verify(expectedCollection, (Deque<String>)q);
        String value2 = "value-" + System.nanoTime();
        Assert.assertFalse((boolean)value1.equals(value2));
        testCollection.addFirst(value2);
        expectedCollection.addFirst(value2);
        this.verify(expectedCollection, (Deque<String>)q);
        testCollection.addLast(value2);
        expectedCollection.addLast(value2);
        this.verify(expectedCollection, (Deque<String>)q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrenceTest() throws Exception {
        AtomicBoolean atomicBoolean;
        LinkedList<String> testCollection = new LinkedList<String>();
        UnmodifiableDeque q = new UnmodifiableDeque(testCollection);
        testCollection.add("value1");
        testCollection.add("value2");
        testCollection.add("value3");
        AtomicBoolean keepWaiting = new AtomicBoolean(true);
        AtomicBoolean clientComplete = new AtomicBoolean(false);
        AtomicBoolean clientReady = new AtomicBoolean(false);
        ArrayList exceptions = new ArrayList();
        Thread client1 = new Thread(new Runnable((Deque)q, clientReady, keepWaiting, exceptions, clientComplete){
            final /* synthetic */ Deque val$q;
            final /* synthetic */ AtomicBoolean val$clientReady;
            final /* synthetic */ AtomicBoolean val$keepWaiting;
            final /* synthetic */ List val$exceptions;
            final /* synthetic */ AtomicBoolean val$clientComplete;
            {
                this.val$q = deque;
                this.val$clientReady = atomicBoolean;
                this.val$keepWaiting = atomicBoolean2;
                this.val$exceptions = list;
                this.val$clientComplete = atomicBoolean3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Iterator iterator = this.val$q.iterator();
                this.val$clientReady.set(true);
                AtomicBoolean atomicBoolean = this.val$clientReady;
                synchronized (atomicBoolean) {
                    this.val$clientReady.notifyAll();
                }
                try {
                    while (iterator.hasNext()) {
                        iterator.next();
                        while (this.val$keepWaiting.get()) {
                            atomicBoolean = this.val$keepWaiting;
                            synchronized (atomicBoolean) {
                                this.val$keepWaiting.wait();
                            }
                        }
                        continue;
                        return;
                    }
                }
                catch (Exception e) {
                    this.val$exceptions.add(e);
                    return;
                }
                finally {
                    this.val$clientComplete.set(true);
                }
            }
        });
        client1.start();
        Assert.assertFalse((boolean)clientComplete.get());
        while (!clientReady.get()) {
            atomicBoolean = clientReady;
            synchronized (atomicBoolean) {
                clientReady.wait();
            }
        }
        Assert.assertEquals((long)3L, (long)testCollection.size());
        testCollection.remove("value2");
        Assert.assertEquals((long)2L, (long)testCollection.size());
        keepWaiting.set(false);
        atomicBoolean = keepWaiting;
        synchronized (atomicBoolean) {
            keepWaiting.notifyAll();
        }
        client1.join();
        Assert.assertTrue((boolean)clientComplete.get());
        Assert.assertEquals((long)1L, (long)exceptions.size());
        Assert.assertTrue((boolean)(exceptions.get(0) instanceof ConcurrentModificationException));
    }

    private void verify(Deque<String> inExpectedCollection, Deque<String> inActualCollection) throws Exception {
        String actualElement;
        String expectedElement;
        Assert.assertNotNull((Object)inActualCollection.toString());
        Assert.assertEquals((Object)inExpectedCollection.isEmpty(), (Object)inActualCollection.isEmpty());
        Assert.assertEquals((long)inExpectedCollection.size(), (long)inActualCollection.size());
        Assert.assertEquals((Object)inExpectedCollection.peek(), (Object)inActualCollection.peek());
        Assert.assertEquals((Object)inExpectedCollection.peekFirst(), (Object)inActualCollection.peekFirst());
        Assert.assertEquals((Object)inExpectedCollection.peekLast(), (Object)inActualCollection.peekLast());
        if (inExpectedCollection.isEmpty()) {
            try {
                inExpectedCollection.getFirst();
                Assert.fail();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                inActualCollection.getFirst();
                Assert.fail();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                inExpectedCollection.getLast();
                Assert.fail();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                inActualCollection.getLast();
                Assert.fail();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                inExpectedCollection.element();
                Assert.fail();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                inActualCollection.element();
                Assert.fail();
            }
            catch (NoSuchElementException noSuchElementException) {}
        } else {
            Assert.assertEquals((Object)inExpectedCollection.getFirst(), (Object)inActualCollection.getFirst());
            Assert.assertEquals((Object)inExpectedCollection.getLast(), (Object)inActualCollection.getLast());
            Assert.assertEquals((Object)inExpectedCollection.element(), (Object)inActualCollection.element());
        }
        Assert.assertTrue((boolean)inActualCollection.containsAll(inExpectedCollection));
        CollectionAssert.assertArrayPermutation((Object[])inExpectedCollection.toArray(), (Object[])inActualCollection.toArray());
        CollectionAssert.assertArrayPermutation((Object[])inExpectedCollection.toArray(new String[0]), (Object[])inActualCollection.toArray(new String[0]));
        Iterator<String> expectedIterator = inExpectedCollection.iterator();
        Iterator<String> actualIterator = inActualCollection.iterator();
        while (expectedIterator.hasNext()) {
            Assert.assertTrue((boolean)actualIterator.hasNext());
            expectedElement = expectedIterator.next();
            actualElement = actualIterator.next();
            Assert.assertEquals((Object)expectedElement, (Object)actualElement);
            Assert.assertTrue((boolean)inActualCollection.contains(actualElement));
            try {
                actualIterator.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        Assert.assertFalse((boolean)actualIterator.hasNext());
        expectedIterator = inExpectedCollection.descendingIterator();
        actualIterator = inActualCollection.descendingIterator();
        while (expectedIterator.hasNext()) {
            Assert.assertTrue((boolean)actualIterator.hasNext());
            expectedElement = expectedIterator.next();
            actualElement = actualIterator.next();
            Assert.assertEquals((Object)expectedElement, (Object)actualElement);
            Assert.assertTrue((boolean)inActualCollection.contains(actualElement));
            try {
                actualIterator.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        Assert.assertFalse((boolean)actualIterator.hasNext());
    }
}

