/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.except;

import java.io.Serializable;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.marketcetera.util.except.I18NThrowable;
import org.marketcetera.util.except.TestMessages;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.test.EqualityAssert;
import org.marketcetera.util.test.SerializableAssert;
import org.marketcetera.util.test.TestCaseBase;

@Ignore
public class I18NThrowableTestBase
extends TestCaseBase {
    protected static final String TEST_MSG_1 = "Test message 1 (expected)";
    protected static final String TEST_MSG_2 = "Test message 2 (expected)";
    protected static final String BOT_MSG = "provider 'util_except_test'; id 'bot_exception'; entry 'msg'; parameters ()";
    protected static final String BOT_MSG_EN = "Bottom-level test exception (expected)";
    protected static final String BOT_MSG_FR = "Niveau bas test exception (attendu)";
    protected static final String MID_MSG_PARAM = "a";
    protected static final String MID_MSG = "provider 'util_except_test'; id 'mid_exception'; entry 'msg'; parameters ('a')";
    protected static final String MID_MSG_EN = "Middle-level test exception (expected) a";
    protected static final String MID_MSG_FR = "Niveau moyen test exception (attendu) a";
    protected static final String TOP_MSG = "provider 'util_except_test'; id 'top_exception'; entry 'msg'; parameters ()";
    protected static final String TOP_MSG_ALL = "Top-level test exception (expected)";

    @Before
    public void setupI18NThrowableTestBase() {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
    }

    private static void equality(I18NThrowable t, Object[] tComps, int copyIndex) {
        EqualityAssert.assertEquality((Object)t, (int)copyIndex, (Object[])tComps);
        SerializableAssert.assertSerializable((Serializable)t);
    }

    protected static void empty(Throwable t1, I18NThrowable t2, I18NThrowable[] t2Comps, int sameIndex) {
        Assert.assertNull((Object)t1.getMessage());
        Assert.assertNull((Object)t1.getLocalizedMessage());
        Assert.assertEquals((Object)t1.getClass().getName(), (Object)t1.toString());
        Assert.assertNull((Object)t2.getI18NBoundMessage());
        Assert.assertNull((Object)t2.getCause());
        Assert.assertNull((Object)t2.getMessage());
        Assert.assertNull((Object)t2.getLocalizedMessage());
        Assert.assertNull((Object)t2.getDetail());
        Assert.assertNull((Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)t2.getClass().getName(), (Object)t2.toString());
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertNull((Object)t2.getMessage());
        Assert.assertNull((Object)t2.getLocalizedMessage());
        Assert.assertNull((Object)t2.getDetail());
        Assert.assertNull((Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)t2.getClass().getName(), (Object)t2.toString());
        I18NThrowableTestBase.equality(t2, t2Comps, sameIndex);
    }

    protected static void causeWithoutMessage(Throwable tNested, Throwable t1, I18NThrowable t2, I18NThrowable[] t2Comps, int sameIndex) {
        String nestedMessage = tNested.getClass().getName();
        Assert.assertEquals((Object)nestedMessage, (Object)t1.getMessage());
        Assert.assertEquals((Object)nestedMessage, (Object)t1.getLocalizedMessage());
        Assert.assertEquals((Object)(t1.getClass().getName() + ": " + nestedMessage), (Object)t1.toString());
        Assert.assertNull((Object)t2.getI18NBoundMessage());
        Assert.assertEquals((Object)tNested, (Object)t2.getCause());
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getMessage());
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getLocalizedMessage());
        Assert.assertNull((Object)t2.getDetail());
        Assert.assertNull((Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + nestedMessage), (Object)t2.toString());
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getMessage());
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getLocalizedMessage());
        Assert.assertNull((Object)t2.getDetail());
        Assert.assertNull((Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + nestedMessage), (Object)t2.toString());
        I18NThrowableTestBase.equality(t2, t2Comps, sameIndex);
    }

    protected static void causeWithMessage(Throwable tNested, Throwable t1, I18NThrowable t2, I18NThrowable[] t2Comps, int sameIndex) {
        String nestedMessage = tNested.getClass().getName() + ": " + TEST_MSG_1;
        Assert.assertEquals((Object)nestedMessage, (Object)t1.getMessage());
        Assert.assertEquals((Object)nestedMessage, (Object)t1.getLocalizedMessage());
        Assert.assertEquals((Object)(t1.getClass().getName() + ": " + nestedMessage), (Object)t1.toString());
        Assert.assertNull((Object)t2.getI18NBoundMessage());
        Assert.assertEquals((Object)tNested, (Object)t2.getCause());
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getMessage());
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t2.getDetail());
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + nestedMessage), (Object)t2.toString());
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getMessage());
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t2.getDetail());
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + nestedMessage), (Object)t2.toString());
        I18NThrowableTestBase.equality(t2, t2Comps, sameIndex);
    }

    protected static void causeWithI18NMessage(I18NThrowable tNested, Throwable t1, I18NThrowable t2, I18NThrowable[] t2Comps, int sameIndex) {
        String nestedMessage = tNested.getClass().getName() + ": " + MID_MSG_EN;
        Assert.assertEquals((Object)nestedMessage, (Object)t1.getMessage());
        Assert.assertEquals((Object)nestedMessage, (Object)t1.getLocalizedMessage());
        Assert.assertEquals((Object)(t1.getClass().getName() + ": " + nestedMessage), (Object)t1.toString());
        Assert.assertNull((Object)t2.getI18NBoundMessage());
        Assert.assertEquals((Object)tNested, (Object)t2.getCause());
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getMessage());
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getDetail());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + nestedMessage), (Object)t2.toString());
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getMessage());
        Assert.assertEquals((Object)nestedMessage, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getDetail());
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + nestedMessage), (Object)t2.toString());
        I18NThrowableTestBase.equality(t2, t2Comps, sameIndex);
    }

    protected static void myMessage(Throwable t1, I18NThrowable t2, I18NThrowable[] t2Comps, int sameIndex) {
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t1.getMessage());
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t1.getLocalizedMessage());
        Assert.assertEquals((Object)(t1.getClass().getName() + ": " + TEST_MSG_1), (Object)t1.toString());
        Assert.assertEquals((String)t2.getDetail(), (Object)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)MID_MSG_PARAM)), (Object)t2.getI18NBoundMessage());
        Assert.assertNull((Object)t2.getCause());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getMessage());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getDetail());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + MID_MSG_EN), (Object)t2.toString());
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getMessage());
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getDetail());
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + MID_MSG_FR), (Object)t2.toString());
        I18NThrowableTestBase.equality(t2, t2Comps, sameIndex);
    }

    protected static void myMessageAndCauseWithoutMessage(Throwable tNested, Throwable t1, I18NThrowable t2, I18NThrowable[] t2Comps, int sameIndex) {
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t1.getMessage());
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t1.getLocalizedMessage());
        Assert.assertEquals((Object)(t1.getClass().getName() + ": " + TEST_MSG_1), (Object)t1.toString());
        Assert.assertEquals((String)t2.getDetail(), (Object)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)MID_MSG_PARAM)), (Object)t2.getI18NBoundMessage());
        Assert.assertEquals((Object)tNested, (Object)t2.getCause());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getMessage());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getDetail());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + MID_MSG_EN), (Object)t2.toString());
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getMessage());
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getDetail());
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + MID_MSG_FR), (Object)t2.toString());
        I18NThrowableTestBase.equality(t2, t2Comps, sameIndex);
    }

    protected static void myMessageAndCauseWithMessage(Throwable tNested, Throwable t1, I18NThrowable t2, I18NThrowable[] t2Comps, int sameIndex) {
        String suffix = " (Test message 2 (expected))";
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t1.getMessage());
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t1.getLocalizedMessage());
        Assert.assertEquals((Object)(t1.getClass().getName() + ": " + TEST_MSG_1), (Object)t1.toString());
        Assert.assertEquals((String)t2.getDetail(), (Object)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)MID_MSG_PARAM)), (Object)t2.getI18NBoundMessage());
        Assert.assertEquals((Object)tNested, (Object)t2.getCause());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getMessage());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)(MID_MSG_EN + suffix), (Object)t2.getDetail());
        Assert.assertEquals((Object)(MID_MSG_EN + suffix), (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + MID_MSG_EN), (Object)t2.toString());
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getMessage());
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)(MID_MSG_FR + suffix), (Object)t2.getDetail());
        Assert.assertEquals((Object)(MID_MSG_FR + suffix), (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + MID_MSG_FR), (Object)t2.toString());
        I18NThrowableTestBase.equality(t2, t2Comps, sameIndex);
    }

    protected static void myMessageAndCauseWithI18NMessage(I18NThrowable tNested, Throwable t1, I18NThrowable t2, I18NThrowable[] t2Comps, int sameIndex) {
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t1.getMessage());
        Assert.assertEquals((Object)TEST_MSG_1, (Object)t1.getLocalizedMessage());
        Assert.assertEquals((Object)(t1.getClass().getName() + ": " + TEST_MSG_1), (Object)t1.toString());
        Assert.assertEquals((String)t2.getDetail(), (Object)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)MID_MSG_PARAM)), (Object)t2.getI18NBoundMessage());
        Assert.assertEquals((Object)tNested, (Object)t2.getCause());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getMessage());
        Assert.assertEquals((Object)MID_MSG_EN, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)"Middle-level test exception (expected) a (Bottom-level test exception (expected))", (Object)t2.getDetail());
        Assert.assertEquals((Object)"Middle-level test exception (expected) a (Bottom-level test exception (expected))", (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + MID_MSG_EN), (Object)t2.toString());
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getMessage());
        Assert.assertEquals((Object)MID_MSG_FR, (Object)t2.getLocalizedMessage());
        Assert.assertEquals((Object)"Niveau moyen test exception (attendu) a (Niveau bas test exception (attendu))", (Object)t2.getDetail());
        Assert.assertEquals((Object)"Niveau moyen test exception (attendu) a (Niveau bas test exception (attendu))", (Object)t2.getLocalizedDetail());
        Assert.assertEquals((Object)(t2.getClass().getName() + ": " + MID_MSG_FR), (Object)t2.toString());
        I18NThrowableTestBase.equality(t2, t2Comps, sameIndex);
    }

    protected static void nesting(I18NThrowable tBot, I18NThrowable tMid, I18NThrowable tTop) {
        Assert.assertEquals((Object)BOT_MSG_EN, (Object)tBot.getDetail());
        Assert.assertEquals((Object)BOT_MSG_EN, (Object)tBot.getLocalizedDetail());
        Assert.assertEquals((Object)"Middle-level test exception (expected) a (Bottom-level test exception (expected))", (Object)tMid.getDetail());
        Assert.assertEquals((Object)"Middle-level test exception (expected) a (Bottom-level test exception (expected))", (Object)tMid.getLocalizedDetail());
        Assert.assertEquals((Object)"Top-level test exception (expected) (Middle-level test exception (expected) a (Bottom-level test exception (expected)))", (Object)tTop.getDetail());
        Assert.assertEquals((Object)"Top-level test exception (expected) (Middle-level test exception (expected) a (Bottom-level test exception (expected)))", (Object)tTop.getLocalizedDetail());
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertEquals((Object)BOT_MSG_FR, (Object)tBot.getDetail());
        Assert.assertEquals((Object)BOT_MSG_FR, (Object)tBot.getLocalizedDetail());
        Assert.assertEquals((Object)"Niveau moyen test exception (attendu) a (Niveau bas test exception (attendu))", (Object)tMid.getDetail());
        Assert.assertEquals((Object)"Niveau moyen test exception (attendu) a (Niveau bas test exception (attendu))", (Object)tMid.getLocalizedDetail());
        Assert.assertEquals((Object)"Top-level test exception (expected) (Niveau moyen test exception (attendu) a (Niveau bas test exception (attendu)))", (Object)tTop.getDetail());
        Assert.assertEquals((Object)"Top-level test exception (expected) (Niveau moyen test exception (attendu) a (Niveau bas test exception (attendu)))", (Object)tTop.getLocalizedDetail());
    }
}

