/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.InputStreamWrapper;
import org.marketcetera.util.file.WrapperTestBase;

public class InputStreamWrapperTest
extends WrapperTestBase {
    @Test
    public void basics() throws Exception {
        CloseCounterInputStream counter = new CloseCounterInputStream();
        InputStreamWrapper out = new InputStreamWrapper((InputStream)counter);
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertFalse((boolean)out.getSkipClose());
        Assert.assertNotNull((Object)out.getStream());
        out.close();
        Assert.assertEquals((long)1L, (long)counter.getClosures());
        out.close();
        Assert.assertEquals((long)1L, (long)counter.getClosures());
        counter = new CloseCounterInputStream();
        out = new InputStreamWrapper((InputStream)counter, true);
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertTrue((boolean)out.getSkipClose());
        Assert.assertNotNull((Object)out.getStream());
        out.close();
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        out.close();
        Assert.assertEquals((long)0L, (long)counter.getClosures());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=FileNotFoundException.class)
    public void nonexistentFileInputStream() throws Exception {
        block5: {
            InputStreamWrapper wrapper = new InputStreamWrapper(TEST_NONEXISTENT_FILE);
            Throwable throwable = null;
            if (wrapper == null) break block5;
            if (throwable != null) {
                try {
                    wrapper.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                wrapper.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void testStandardInputStream(ByteArrayInputStream in) throws Exception {
        try (CloseableRegistry r = new CloseableRegistry();){
            InputStreamWrapper wrapper = new InputStreamWrapper(":stdin:");
            r.register((Closeable)wrapper);
            Assert.assertTrue((boolean)wrapper.getSkipClose());
            Assert.assertNotNull((Object)wrapper.getStream());
            Assert.assertArrayEquals((byte[])VALUE_BYTES, (byte[])IOUtils.toByteArray((InputStream)wrapper.getStream()));
        }
    }

    @Test
    public void wrappers() throws Exception {
        this.testStandardInputStream();
    }

    private static final class CloseCounterInputStream
    extends InputStream {
        private int mClosures = 0;

        private CloseCounterInputStream() {
        }

        int getClosures() {
            return this.mClosures;
        }

        @Override
        public int read() {
            return 0;
        }

        @Override
        public void close() {
            ++this.mClosures;
        }
    }
}

