/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.OutputStreamWrapper;
import org.marketcetera.util.file.WrapperTestBase;

public class OutputStreamWrapperTest
extends WrapperTestBase {
    @Test
    public void basics() throws Exception {
        CloseCounterOutputStream counter = new CloseCounterOutputStream();
        OutputStreamWrapper out = new OutputStreamWrapper((OutputStream)counter);
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertEquals((long)0L, (long)counter.getFlushes());
        Assert.assertFalse((boolean)out.getSkipClose());
        Assert.assertNotNull((Object)out.getStream());
        out.close();
        Assert.assertEquals((long)1L, (long)counter.getClosures());
        Assert.assertEquals((long)1L, (long)counter.getFlushes());
        out.close();
        Assert.assertEquals((long)1L, (long)counter.getClosures());
        Assert.assertEquals((long)1L, (long)counter.getFlushes());
        counter = new CloseCounterOutputStream();
        out = new OutputStreamWrapper((OutputStream)counter, true);
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertEquals((long)0L, (long)counter.getFlushes());
        Assert.assertTrue((boolean)out.getSkipClose());
        Assert.assertNotNull((Object)out.getStream());
        out.close();
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertEquals((long)1L, (long)counter.getFlushes());
        out.close();
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertEquals((long)2L, (long)counter.getFlushes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=FileNotFoundException.class)
    public void nonexistentFile() throws Exception {
        block5: {
            OutputStreamWrapper wrapper = new OutputStreamWrapper(TEST_NONEXISTENT_FILE);
            Throwable throwable = null;
            if (wrapper == null) break block5;
            if (throwable != null) {
                try {
                    wrapper.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                wrapper.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testStandardStream(String name, ByteArrayOutputStream out) throws Exception {
        try (CloseableRegistry r = new CloseableRegistry();){
            OutputStreamWrapper wrapper = new OutputStreamWrapper(name);
            r.register((Closeable)wrapper);
            Assert.assertTrue((boolean)wrapper.getSkipClose());
            Assert.assertNotNull((Object)wrapper.getStream());
            wrapper.getStream().write(VALUE_BYTES);
        }
        Assert.assertArrayEquals((byte[])VALUE_BYTES, (byte[])out.toByteArray());
    }

    @Override
    protected void testStandardOutputStream(ByteArrayOutputStream out) throws Exception {
        OutputStreamWrapperTest.testStandardStream(":stdout:", out);
    }

    @Override
    protected void testStandardErrorStream(ByteArrayOutputStream err) throws Exception {
        OutputStreamWrapperTest.testStandardStream(":stderr:", err);
    }

    @Test
    public void wrappers() throws Exception {
        this.testStandardOutputStream();
        this.testStandardErrorStream();
    }

    private static final class CloseCounterOutputStream
    extends OutputStream {
        private int mClosures = 0;
        private int mFlushes = 0;

        private CloseCounterOutputStream() {
        }

        int getClosures() {
            return this.mClosures;
        }

        int getFlushes() {
            return this.mFlushes;
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void flush() {
            ++this.mFlushes;
        }

        @Override
        public void close() {
            ++this.mClosures;
        }
    }
}

