/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.ReaderWrapper;
import org.marketcetera.util.file.WrapperTestBase;
import org.marketcetera.util.test.UnicodeData;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.Signature;

public class ReaderWrapperTest
extends WrapperTestBase {
    @Test
    public void basics() throws Exception {
        CloseCounterReader counter = new CloseCounterReader();
        ReaderWrapper out = new ReaderWrapper((Reader)counter);
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertFalse((boolean)out.getSkipClose());
        Assert.assertNotNull((Object)out.getReader());
        out.close();
        Assert.assertEquals((long)1L, (long)counter.getClosures());
        out.close();
        Assert.assertEquals((long)1L, (long)counter.getClosures());
        counter = new CloseCounterReader();
        out = new ReaderWrapper((Reader)counter, true);
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertTrue((boolean)out.getSkipClose());
        Assert.assertNotNull((Object)out.getReader());
        out.close();
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        out.close();
        Assert.assertEquals((long)0L, (long)counter.getClosures());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=FileNotFoundException.class)
    public void nonexistentFileReader() throws Exception {
        block5: {
            ReaderWrapper wrapper = new ReaderWrapper(TEST_NONEXISTENT_FILE);
            Throwable throwable = null;
            if (wrapper == null) break block5;
            if (throwable != null) {
                try {
                    wrapper.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                wrapper.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void testStandardInputStream(ByteArrayInputStream in) throws Exception {
        try (CloseableRegistry r = new CloseableRegistry();){
            ReaderWrapper wrapper = new ReaderWrapper(":stdin:");
            r.register((Closeable)wrapper);
            Assert.assertTrue((boolean)wrapper.getSkipClose());
            Assert.assertNotNull((Object)wrapper.getReader());
            Assert.assertEquals((Object)"Hello", (Object)IOUtils.toString((Reader)wrapper.getReader()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStandardInputStreamUnicode() throws Exception {
        InputStream stdInSave = System.in;
        CloseableRegistry r = new CloseableRegistry();
        try {
            ByteArrayInputStream stdIn = new ByteArrayInputStream(ArrayUtils.addAll((byte[])Signature.UTF8.getMark(), (byte[])UnicodeData.COMBO_UTF8));
            r.register((Closeable)stdIn);
            System.setIn(stdIn);
            ReaderWrapper wrapper = new ReaderWrapper(":stdin:", DecodingStrategy.SIG_REQ);
            r.register((Closeable)wrapper);
            Assert.assertTrue((boolean)wrapper.getSkipClose());
            Assert.assertNotNull((Object)wrapper.getReader());
            Assert.assertEquals((Object)"Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", (Object)IOUtils.toString((Reader)wrapper.getReader()));
        }
        finally {
            System.setIn(stdInSave);
            r.close();
        }
    }

    @Test
    public void wrappers() throws Exception {
        this.testStandardInputStream();
        this.testStandardInputStreamUnicode();
    }

    private static final class CloseCounterReader
    extends Reader {
        private int mClosures = 0;

        private CloseCounterReader() {
        }

        int getClosures() {
            return this.mClosures;
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            return 0;
        }

        @Override
        public void close() {
            ++this.mClosures;
        }
    }
}

