/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.l10n;

import java.io.Serializable;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.l10n.ContainerClassInfo;
import org.marketcetera.util.l10n.I18NMessageInfo;
import org.marketcetera.util.l10n.Messages;
import org.marketcetera.util.l10n.TestMessages;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.log.I18NLoggerProxy;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessage1P;
import org.marketcetera.util.log.I18NMessageProvider;
import org.marketcetera.util.test.CollectionAssert;
import org.marketcetera.util.test.TestCaseBase;

public class ContainerClassInfoTest
extends TestCaseBase {
    @Test
    public void all() throws Exception {
        ContainerClassInfo info = new ContainerClassInfo(TestMessages.class);
        Assert.assertEquals(TestMessages.class, (Object)info.getContainer());
        Assert.assertEquals((Object)TestMessages.PROVIDER, (Object)info.getProvider());
        CollectionAssert.assertArrayPermutation((Object[])new I18NMessageInfo[]{new I18NMessageInfo("m0.msg", 0, (I18NMessage)TestMessages.M0_MSG), new I18NMessageInfo("m1.msg", 1, (I18NMessage)TestMessages.M1_MSG), new I18NMessageInfo("m2.msg", 2, (I18NMessage)TestMessages.M2_MSG), new I18NMessageInfo("m3.msg", 3, (I18NMessage)TestMessages.M3_MSG), new I18NMessageInfo("m4.msg", 4, (I18NMessage)TestMessages.M4_MSG), new I18NMessageInfo("m5.msg", 5, (I18NMessage)TestMessages.M5_MSG), new I18NMessageInfo("m6.msg", 6, (I18NMessage)TestMessages.M6_MSG), new I18NMessageInfo("m7.msg", -1, (I18NMessage)TestMessages.M7_MSG), new I18NMessageInfo("m8.msg", -1, (I18NMessage)TestMessages.M8_MSG)}, (Object[])info.getMessageInfo().toArray(I18NMessageInfo.EMPTY_ARRAY));
    }

    @Test
    public void emptyWithProvider() throws Exception {
        ContainerClassInfo info = new ContainerClassInfo(EmptyWithProvider.class);
        Assert.assertEquals(EmptyWithProvider.class, (Object)info.getContainer());
        Assert.assertEquals((Object)EmptyWithProvider.PROVIDER, (Object)info.getProvider());
        Assert.assertArrayEquals((Object[])I18NMessageInfo.EMPTY_ARRAY, (Object[])info.getMessageInfo().toArray(I18NMessageInfo.EMPTY_ARRAY));
    }

    @Test
    public void nonstandardFields() throws Exception {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
        ContainerClassInfo info = new ContainerClassInfo(NonstandardFields.class);
        Assert.assertEquals(NonstandardFields.class, (Object)info.getContainer());
        Assert.assertEquals((Object)NonstandardFields.PROVIDER, (Object)info.getProvider());
        CollectionAssert.assertArrayPermutation((Object[])new I18NMessageInfo[]{new I18NMessageInfo("m0.msg", 0, (I18NMessage)NonstandardFields.M0_MSG)}, (Object[])info.getMessageInfo().toArray(I18NMessageInfo.EMPTY_ARRAY));
    }

    @Test
    public void missingProvider() {
        try {
            new ContainerClassInfo(EmptyNoProvider.class);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.MISSING_PROVIDER, (Serializable)((Object)EmptyNoProvider.class.getName())), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void multipleProviders() {
        try {
            new ContainerClassInfo(MultipleProviders.class);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage3P(Messages.MULTIPLE_PROVIDERS, (Serializable)((Object)MultipleProviders.class.getName()), (Serializable)((Object)MultipleProviders.PROVIDER2.getProviderId()), (Serializable)((Object)MultipleProviders.PROVIDER1.getProviderId())), (Object)ex.getI18NBoundMessage());
        }
    }

    private static class NonstandardFields {
        static final I18NMessageProvider PROVIDER = TestMessages.PROVIDER;
        static I18NLoggerProxy LOGGER = new I18NLoggerProxy(PROVIDER);
        static final int INTEGER_FIELD = 1;
        protected static I18NMessage0P M0_MSG = new I18NMessage0P(LOGGER, "m0");
        I18NMessage1P M1_MSG = new I18NMessage1P(LOGGER, "m1");
        static I18NMessage1P M2_MSG;

        private NonstandardFields() {
        }
    }

    private static interface MultipleProviders {
        public static final I18NMessageProvider PROVIDER1 = Messages.PROVIDER;
        public static final I18NMessageProvider PROVIDER2 = TestMessages.PROVIDER;
    }

    private static interface EmptyWithProvider {
        public static final I18NMessageProvider PROVIDER = TestMessages.PROVIDER;
    }

    private static interface EmptyNoProvider {
    }
}

