/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage4P;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessage4P;
import org.marketcetera.util.log.I18NMessageTestBase;
import org.marketcetera.util.log.TestMessages;

public class TI18NMessage4PTest
extends I18NMessageTestBase {
    private static final String TEST_MSG_EN = "P4 msg (expected) en 1 2 3 4";
    private static final String TEST_TTL_EN = "P4 ttl (expected) en 1 2 3 4";
    private static final String TEST_MSG_FR = "P4 msg (expected) fr 1 2 3 4";
    private static final String TEST_TTL_FR = "P4 ttl (expected) fr 1 2 3 4";

    private static void castOverride(I18NMessage4P m) {
    }

    @Test
    public void basic() {
        TI18NMessage4PTest.unboundTests(4, (I18NMessage)new I18NMessage4P(TestMessages.LOGGER, "base", "ttl"), (I18NMessage)new I18NMessage4P(TestMessages.LOGGER, "base", "ttl"), new I18NMessage[]{new I18NMessage4P(TEST_LOGGER_D, "base", "ttl"), new I18NMessage4P(TestMessages.LOGGER, "baseD", "ttl"), new I18NMessage4P(TestMessages.LOGGER, "base", "ttlD"), new I18NMessage0P(TestMessages.LOGGER, "base", "ttl")}, (I18NMessage)new I18NMessage4P(TestMessages.LOGGER, "base"));
    }

    @Test
    public void messageProvider() {
        Assert.assertEquals((Object)TEST_MSG_EN, (Object)TestMessages.P4_MSG.getText((Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        Assert.assertEquals((Object)TEST_TTL_EN, (Object)TestMessages.P4_TTL.getText((Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        Assert.assertEquals((Object)TEST_MSG_FR, (Object)TestMessages.P4_MSG.getText(Locale.FRENCH, (Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        Assert.assertEquals((Object)TEST_TTL_FR, (Object)TestMessages.P4_TTL.getText(Locale.FRENCH, (Object)"1", (Object)"2", (Object)"3", (Object)"4"));
    }

    @Test
    public void loggerProxy() {
        TestMessages.P4_MSG.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_MSG.error((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_TTL.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_TTL.error((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_MSG.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_MSG.warn((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_TTL.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_TTL.warn((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_MSG.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_MSG.info((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_TTL.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_TTL.info((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_MSG.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_MSG.debug((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_TTL.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_TTL.debug((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_MSG.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_MSG.trace((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_TTL.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        TestMessages.P4_TTL.trace((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4");
    }

    @Test
    public void bound() {
        Serializable[] params = new Serializable[]{"1", "2", "3", "4"};
        I18NBoundMessage4P m = new I18NBoundMessage4P(TestMessages.P4_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"));
        this.boundTests((I18NBoundMessage)m, (I18NBoundMessage)new I18NBoundMessage4P(TestMessages.P4_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4")), new I18NBoundMessage[]{new I18NBoundMessage4P(TestMessages.P4_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"1")), new I18NBoundMessage4P(TestMessages.P4_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4")), TestMessages.P0_MSG}, params, (I18NMessage)TestMessages.P4_MSG, TEST_MSG_EN, TEST_MSG_FR);
        TI18NMessage4PTest.castOverride((I18NMessage4P)m.getMessage());
        this.boundTests((I18NBoundMessage)new I18NBoundMessage4P(TestMessages.P4_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4")), (I18NBoundMessage)new I18NBoundMessage4P(TestMessages.P4_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4")), new I18NBoundMessage[]{new I18NBoundMessage4P(TestMessages.P4_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"1")), new I18NBoundMessage4P(TestMessages.P4_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4")), TestMessages.P0_TTL}, params, (I18NMessage)TestMessages.P4_TTL, TEST_TTL_EN, TEST_TTL_FR);
        Assert.assertEquals((Object)"1", (Object)m.getParam1());
        Assert.assertEquals((Object)"2", (Object)m.getParam2());
        Assert.assertEquals((Object)"3", (Object)m.getParam3());
        Assert.assertEquals((Object)"4", (Object)m.getParam4());
    }
}

