/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.quickfix;

import java.util.Date;
import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.marketcetera.util.quickfix.AnalyzedField;
import org.marketcetera.util.quickfix.AnalyzedGroup;
import org.marketcetera.util.quickfix.AnalyzedMessage;
import org.marketcetera.util.quickfix.AnalyzerTestBase;
import quickfix.Group;
import quickfix.IntField;
import quickfix.Message;
import quickfix.StringField;
import quickfix.UtcTimeStampField;
import quickfix.field.Account;
import quickfix.field.ClOrdID;
import quickfix.field.HandlInst;
import quickfix.field.Issuer;
import quickfix.field.MDEntryPx;
import quickfix.field.MDEntrySize;
import quickfix.field.MDEntryType;
import quickfix.field.MsgSeqNum;
import quickfix.field.NoMDEntries;
import quickfix.field.OrdType;
import quickfix.field.OrderID;
import quickfix.field.QuoteEntryID;
import quickfix.field.QuoteSetID;
import quickfix.field.SenderCompID;
import quickfix.field.SendingTime;
import quickfix.field.Side;
import quickfix.field.Symbol;
import quickfix.field.TargetCompID;
import quickfix.field.TransactTime;
import quickfix.field.UnderlyingIssuer;
import quickfix.fix42.MarketDataSnapshotFullRefresh;
import quickfix.fix42.MassQuote;
import quickfix.fix42.NewOrderSingle;

public class AnalyzedMessageTest
extends AnalyzerTestBase {
    @Ignore
    @Test
    public void empty() throws Exception {
        NewOrderSingle msg = new NewOrderSingle();
        msg.toString();
        AnalyzedMessage msgA = new AnalyzedMessage(TEST_DICTIONARY, (Message)msg);
        Assert.assertEquals((long)3L, (long)msgA.getHeader().size());
        Assert.assertEquals((long)0L, (long)msgA.getBody().size());
        Assert.assertEquals((long)1L, (long)msgA.getTrailer().size());
        Assert.assertEquals((Object)(TEST_HEADER + "5" + SystemUtils.LINE_SEPARATOR + " MsgType [35R] = NewOrderSingle [D]" + TEST_FOOTER + "181"), (Object)msgA.toString());
    }

    @Test
    public void valid() throws Exception {
        NewOrderSingle msg = new NewOrderSingle();
        msg.getHeader().setField((StringField)new SenderCompID("me"));
        msg.getHeader().setField((StringField)new TargetCompID("you"));
        msg.getHeader().setField((IntField)new MsgSeqNum(1));
        msg.getHeader().setField((UtcTimeStampField)new SendingTime(new Date(2L)));
        msg.set(new ClOrdID("a"));
        msg.set(new HandlInst('1'));
        msg.set(new TransactTime(new Date(3L)));
        msg.set(new OrdType('2'));
        msg.set(new Symbol("METC"));
        msg.set(new Side('1'));
        msg.set(new Account("metc"));
        msg.toString();
        AnalyzedMessage msgA = new AnalyzedMessage(TEST_DICTIONARY, (Message)msg);
        Assert.assertEquals((long)7L, (long)msgA.getHeader().size());
        Assert.assertEquals((long)7L, (long)msgA.getBody().size());
        Assert.assertEquals((long)1L, (long)msgA.getTrailer().size());
        Assert.assertEquals((Object)(SystemUtils.LINE_SEPARATOR + "Header" + SystemUtils.LINE_SEPARATOR + " BeginString [8R] = FIX.4.2" + SystemUtils.LINE_SEPARATOR + " BodyLength [9R] = 108" + SystemUtils.LINE_SEPARATOR + " MsgSeqNum [34R] = 1" + SystemUtils.LINE_SEPARATOR + " MsgType [35R] = NewOrderSingle [D]" + SystemUtils.LINE_SEPARATOR + " SenderCompID [49R] = me" + SystemUtils.LINE_SEPARATOR + " SendingTime [52R] = 19700101-00:00:00.002" + SystemUtils.LINE_SEPARATOR + " TargetCompID [56R] = you" + SystemUtils.LINE_SEPARATOR + "Body" + SystemUtils.LINE_SEPARATOR + " Account [1] = metc" + SystemUtils.LINE_SEPARATOR + " ClOrdID [11R] = a" + SystemUtils.LINE_SEPARATOR + " HandlInst [21R] = " + "AUTOMATED_EXECUTION_ORDER_PRIVATE_NO_BROKER_INTERVENTION [1]" + SystemUtils.LINE_SEPARATOR + " OrdType [40R] = LIMIT [2]" + SystemUtils.LINE_SEPARATOR + " Side [54R] = BUY [1]" + SystemUtils.LINE_SEPARATOR + " Symbol [55R] = METC" + SystemUtils.LINE_SEPARATOR + " TransactTime [60R] = 19700101-00:00:00.003" + TEST_FOOTER + "076"), (Object)msgA.toString());
    }

    @Ignore
    @Test
    public void group() throws Exception {
        MarketDataSnapshotFullRefresh msg = new MarketDataSnapshotFullRefresh(new Symbol("QF"));
        MarketDataSnapshotFullRefresh.NoMDEntries group = new MarketDataSnapshotFullRefresh.NoMDEntries();
        group.set(new MDEntryType('0'));
        group.set(new MDEntryPx(2.0));
        group.set(new MDEntrySize(16.0));
        group.set(new OrderID("ID1"));
        msg.addGroup((Group)group);
        group = new MarketDataSnapshotFullRefresh.NoMDEntries();
        group.set(new MDEntryType('?'));
        group.set(new MDEntryPx(4.0));
        group.set(new MDEntrySize(32.0));
        group.set(new OrderID("ID2"));
        msg.addGroup((Group)group);
        msg.toString();
        AnalyzedMessage msgA = new AnalyzedMessage(TEST_DICTIONARY, (Message)msg);
        Assert.assertEquals((long)3L, (long)msgA.getHeader().size());
        Assert.assertEquals((long)2L, (long)msgA.getBody().size());
        Assert.assertEquals((long)4L, (long)((AnalyzedGroup)((AnalyzedField)msgA.getBody().get(1)).getGroups().get(0)).getFields().size());
        Assert.assertEquals((long)4L, (long)((AnalyzedGroup)((AnalyzedField)msgA.getBody().get(1)).getGroups().get(1)).getFields().size());
        Assert.assertEquals((long)1L, (long)msgA.getTrailer().size());
        Assert.assertEquals((Object)(TEST_HEADER + "69" + SystemUtils.LINE_SEPARATOR + " MsgType [35R] = MarketDataSnapshotFullRefresh [W]" + SystemUtils.LINE_SEPARATOR + "Body" + SystemUtils.LINE_SEPARATOR + " Symbol [55R] = QF" + SystemUtils.LINE_SEPARATOR + " NoMDEntries [268R] = 2" + SystemUtils.LINE_SEPARATOR + "  Group 1" + SystemUtils.LINE_SEPARATOR + "   MDEntryType [269R] = BID [0]" + SystemUtils.LINE_SEPARATOR + "   OrderID [37] = ID1" + SystemUtils.LINE_SEPARATOR + "   MDEntryPx [270R] = 2" + SystemUtils.LINE_SEPARATOR + "   MDEntrySize [271] = 16" + SystemUtils.LINE_SEPARATOR + "  Group 2" + SystemUtils.LINE_SEPARATOR + "   MDEntryType [269R] = ? [invalid]" + SystemUtils.LINE_SEPARATOR + "   OrderID [37] = ID2" + SystemUtils.LINE_SEPARATOR + "   MDEntryPx [270R] = 4" + SystemUtils.LINE_SEPARATOR + "   MDEntrySize [271] = 32" + TEST_FOOTER + "219"), (Object)msgA.toString());
    }

    @Ignore
    @Test
    public void nestedGroup() throws Exception {
        MassQuote msg = new MassQuote();
        MassQuote.NoQuoteSets topGroup = new MassQuote.NoQuoteSets();
        topGroup.set(new QuoteSetID("TID1"));
        topGroup.set(new UnderlyingIssuer("UI1"));
        MassQuote.NoQuoteSets.NoQuoteEntries nestedGroup = new MassQuote.NoQuoteSets.NoQuoteEntries();
        nestedGroup.set(new QuoteEntryID("NID1.1"));
        nestedGroup.set(new Issuer("I1.1"));
        topGroup.addGroup((Group)nestedGroup);
        nestedGroup = new MassQuote.NoQuoteSets.NoQuoteEntries();
        nestedGroup.set(new QuoteEntryID("NID1.2"));
        nestedGroup.set(new Issuer("I1.2"));
        topGroup.addGroup((Group)nestedGroup);
        msg.addGroup((Group)topGroup);
        topGroup = new MassQuote.NoQuoteSets();
        topGroup.set(new QuoteSetID("TID2"));
        topGroup.set(new UnderlyingIssuer("UI2"));
        nestedGroup = new MassQuote.NoQuoteSets.NoQuoteEntries();
        nestedGroup.set(new QuoteEntryID("NID2.1"));
        nestedGroup.set(new Issuer("I2.1"));
        topGroup.addGroup((Group)nestedGroup);
        nestedGroup = new MassQuote.NoQuoteSets.NoQuoteEntries();
        nestedGroup.set(new QuoteEntryID("NID2.2"));
        nestedGroup.set(new Issuer("I2.2"));
        topGroup.addGroup((Group)nestedGroup);
        msg.addGroup((Group)topGroup);
        msg.toString();
        AnalyzedMessage msgA = new AnalyzedMessage(TEST_DICTIONARY, (Message)msg);
        Assert.assertEquals((long)3L, (long)msgA.getHeader().size());
        Assert.assertEquals((long)1L, (long)msgA.getBody().size());
        Assert.assertEquals((long)3L, (long)((AnalyzedGroup)((AnalyzedField)msgA.getBody().get(0)).getGroups().get(0)).getFields().size());
        Assert.assertEquals((long)2L, (long)((AnalyzedGroup)((AnalyzedField)((AnalyzedGroup)((AnalyzedField)msgA.getBody().get(0)).getGroups().get(0)).getFields().get(1)).getGroups().get(0)).getFields().size());
        Assert.assertEquals((long)2L, (long)((AnalyzedGroup)((AnalyzedField)((AnalyzedGroup)((AnalyzedField)msgA.getBody().get(0)).getGroups().get(0)).getFields().get(1)).getGroups().get(1)).getFields().size());
        Assert.assertEquals((long)3L, (long)((AnalyzedGroup)((AnalyzedField)msgA.getBody().get(0)).getGroups().get(1)).getFields().size());
        Assert.assertEquals((long)2L, (long)((AnalyzedGroup)((AnalyzedField)((AnalyzedGroup)((AnalyzedField)msgA.getBody().get(0)).getGroups().get(1)).getFields().get(1)).getGroups().get(0)).getFields().size());
        Assert.assertEquals((long)2L, (long)((AnalyzedGroup)((AnalyzedField)((AnalyzedGroup)((AnalyzedField)msgA.getBody().get(0)).getGroups().get(1)).getFields().get(1)).getGroups().get(1)).getFields().size());
        Assert.assertEquals((long)1L, (long)msgA.getTrailer().size());
        Assert.assertEquals((Object)(TEST_HEADER + "137" + SystemUtils.LINE_SEPARATOR + " MsgType [35R] = MassQuote [i]" + SystemUtils.LINE_SEPARATOR + "Body" + SystemUtils.LINE_SEPARATOR + " NoQuoteSets [296R] = 2" + SystemUtils.LINE_SEPARATOR + "  Group 1" + SystemUtils.LINE_SEPARATOR + "   QuoteSetID [302R] = TID1" + SystemUtils.LINE_SEPARATOR + "   NoQuoteEntries [295R] = 2" + SystemUtils.LINE_SEPARATOR + "    Group 1" + SystemUtils.LINE_SEPARATOR + "     QuoteEntryID [299R] = NID1.1" + SystemUtils.LINE_SEPARATOR + "     Issuer [106] = I1.1" + SystemUtils.LINE_SEPARATOR + "    Group 2" + SystemUtils.LINE_SEPARATOR + "     QuoteEntryID [299R] = NID1.2" + SystemUtils.LINE_SEPARATOR + "     Issuer [106] = I1.2" + SystemUtils.LINE_SEPARATOR + "   UnderlyingIssuer [306] = UI1" + SystemUtils.LINE_SEPARATOR + "  Group 2" + SystemUtils.LINE_SEPARATOR + "   QuoteSetID [302R] = TID2" + SystemUtils.LINE_SEPARATOR + "   NoQuoteEntries [295R] = 2" + SystemUtils.LINE_SEPARATOR + "    Group 1" + SystemUtils.LINE_SEPARATOR + "     QuoteEntryID [299R] = NID2.1" + SystemUtils.LINE_SEPARATOR + "     Issuer [106] = I2.1" + SystemUtils.LINE_SEPARATOR + "    Group 2" + SystemUtils.LINE_SEPARATOR + "     QuoteEntryID [299R] = NID2.2" + SystemUtils.LINE_SEPARATOR + "     Issuer [106] = I2.2" + SystemUtils.LINE_SEPARATOR + "   UnderlyingIssuer [306] = UI2" + TEST_FOOTER + "125"), (Object)msgA.toString());
    }

    @Test
    public void missingType() throws Exception {
        Message msg = new Message();
        msg.toString();
        AnalyzedMessage msgA = new AnalyzedMessage(TEST_DICTIONARY, msg);
        Assert.assertEquals((long)0L, (long)msgA.getHeader().size());
        Assert.assertEquals((long)0L, (long)msgA.getBody().size());
        Assert.assertEquals((long)0L, (long)msgA.getTrailer().size());
        Assert.assertEquals((Object)"", (Object)msgA.toString());
    }

    @Ignore
    @Test
    public void badEnum() throws Exception {
        NewOrderSingle msg = new NewOrderSingle();
        msg.set(new Side('?'));
        msg.toString();
        AnalyzedMessage msgA = new AnalyzedMessage(TEST_DICTIONARY, (Message)msg);
        Assert.assertEquals((long)3L, (long)msgA.getHeader().size());
        Assert.assertEquals((long)1L, (long)msgA.getBody().size());
        Assert.assertEquals((long)1L, (long)msgA.getTrailer().size());
        Assert.assertEquals((Object)(TEST_HEADER + "10" + SystemUtils.LINE_SEPARATOR + " MsgType [35R] = NewOrderSingle [D]" + SystemUtils.LINE_SEPARATOR + "Body" + SystemUtils.LINE_SEPARATOR + " Side [54R] = ? [invalid]" + TEST_FOOTER + "199"), (Object)msgA.toString());
    }

    @Ignore
    @Test
    public void missingGroup() throws Exception {
        MarketDataSnapshotFullRefresh msg = new MarketDataSnapshotFullRefresh(new Symbol("QF"));
        msg.set(new NoMDEntries(1));
        msg.toString();
        AnalyzedMessage msgA = new AnalyzedMessage(TEST_DICTIONARY, (Message)msg);
        Assert.assertEquals((long)3L, (long)msgA.getHeader().size());
        Assert.assertEquals((long)2L, (long)msgA.getBody().size());
        Assert.assertEquals((long)1L, (long)msgA.getTrailer().size());
        Assert.assertEquals((Object)(TEST_HEADER + "17" + SystemUtils.LINE_SEPARATOR + " MsgType [35R] = MarketDataSnapshotFullRefresh [W]" + SystemUtils.LINE_SEPARATOR + "Body" + SystemUtils.LINE_SEPARATOR + " Symbol [55R] = QF" + SystemUtils.LINE_SEPARATOR + " NoMDEntries [268R] = 1" + TEST_FOOTER + "052"), (Object)msgA.toString());
    }
}

