/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.io.File;
import org.apache.commons.lang.ArrayUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.marketcetera.util.file.Deleter;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.test.UnicodeData;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.Signature;
import org.marketcetera.util.unicode.SignatureCharset;

@Ignore
public abstract class IOTestBase
extends TestCaseBase {
    protected static final String TEST_FILE_ROOT = DIR_ROOT + File.separator + "unicode" + File.separator;
    protected static final String TEST_FILE = TEST_FILE_ROOT + "sample.txt";

    protected abstract void testNative() throws Exception;

    protected abstract void testSignatureCharset(SignatureCharset var1, byte[] var2) throws Exception;

    protected abstract void testStrategy(DecodingStrategy var1, SignatureCharset var2, String var3, byte[] var4) throws Exception;

    @Before
    @After
    public void setupTearDownIOTest() throws Exception {
        Deleter.apply((String)TEST_FILE);
    }

    @Test
    public void all() throws Exception {
        this.testNative();
        this.testSignatureCharset(SignatureCharset.NONE_UTF16BE, UnicodeData.COMBO_UTF16BE);
        this.testSignatureCharset(SignatureCharset.NONE_UTF16LE, UnicodeData.COMBO_UTF16LE);
        this.testSignatureCharset(SignatureCharset.NONE_UTF32BE, UnicodeData.COMBO_UTF32BE);
        this.testSignatureCharset(SignatureCharset.NONE_UTF32LE, UnicodeData.COMBO_UTF32LE);
        this.testSignatureCharset(SignatureCharset.UTF8_UTF8, ArrayUtils.addAll((byte[])Signature.UTF8.getMark(), (byte[])UnicodeData.COMBO_UTF8));
        this.testSignatureCharset(SignatureCharset.UTF16BE_UTF16BE, ArrayUtils.addAll((byte[])Signature.UTF16BE.getMark(), (byte[])UnicodeData.COMBO_UTF16BE));
        this.testSignatureCharset(SignatureCharset.UTF16LE_UTF16LE, ArrayUtils.addAll((byte[])Signature.UTF16LE.getMark(), (byte[])UnicodeData.COMBO_UTF16LE));
        this.testSignatureCharset(SignatureCharset.UTF32BE_UTF32BE, ArrayUtils.addAll((byte[])Signature.UTF32BE.getMark(), (byte[])UnicodeData.COMBO_UTF32BE));
        this.testSignatureCharset(SignatureCharset.UTF32LE_UTF32LE, ArrayUtils.addAll((byte[])Signature.UTF32LE.getMark(), (byte[])UnicodeData.COMBO_UTF32LE));
        this.testStrategy(DecodingStrategy.UTF8_DEFAULT, SignatureCharset.NONE_UTF8, "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", UnicodeData.COMBO_UTF8);
        this.testStrategy(DecodingStrategy.UTF16_DEFAULT, SignatureCharset.NONE_UTF16BE, "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", UnicodeData.COMBO_UTF16BE);
        this.testStrategy(DecodingStrategy.UTF32_DEFAULT, SignatureCharset.NONE_UTF32BE, "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", UnicodeData.COMBO_UTF32BE);
        this.testStrategy(DecodingStrategy.SIG_REQ, null, "Hello", UnicodeData.HELLO_EN_NAT);
    }
}

