/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import java.io.Serializable;
import java.util.Locale;
import org.junit.Assert;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateful.RemoteCall;
import org.marketcetera.util.ws.stateful.RemoteCaller;
import org.marketcetera.util.ws.stateful.RemoteRunner;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateful.TestMessages;
import org.marketcetera.util.ws.stateless.Messages;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.stateless.StatelessRemoteCall;
import org.marketcetera.util.ws.stateless.StatelessRemoteCallTestBase;
import org.marketcetera.util.ws.tags.EqualsTagFilter;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.tags.ValidSessionTagFilter;
import org.marketcetera.util.ws.tags.VersionId;
import org.marketcetera.util.ws.wrappers.RemoteException;

public class RemoteCallTestBase
extends StatelessRemoteCallTestBase {
    protected static final EqualsTagFilter TEST_SESSION_FILTER = new EqualsTagFilter(null, TestMessages.MESSAGE);
    protected static final SessionManager<Object> TEST_MANAGER = new SessionManager();
    private static final SessionId TEST_SESSION = SessionId.generate();
    private static final SessionId TEST_SESSION_D = SessionId.generate();
    private static final String TEST_USER = "metc";
    private static final StatelessClientContext TEST_CONTEXT = new StatelessClientContext();
    protected static final SessionHolder<Object> TEST_HOLDER = new SessionHolder("metc", TEST_CONTEXT);

    protected static void single(RemoteCall<?> call, RemoteCall<?> empty, RemoteCall<?> defaults) {
        RemoteCallTestBase.single(call, empty, defaults);
        Assert.assertEquals((Object)TEST_SESSION_FILTER, (Object)call.getSessionIdFilter());
        Assert.assertEquals(TEST_MANAGER, (Object)call.getSessionManager());
        Assert.assertNull((Object)empty.getSessionIdFilter());
        Assert.assertNull((Object)empty.getSessionManager());
        Assert.assertEquals(TEST_MANAGER, (Object)((ValidSessionTagFilter)defaults.getSessionIdFilter()).getSessionManager());
        Assert.assertEquals(TEST_MANAGER, (Object)defaults.getSessionManager());
    }

    private static void fillContext(ClientContext context) {
        RemoteCallTestBase.fillContext((StatelessClientContext)context);
        context.setSessionId(TEST_SESSION);
    }

    private <T> void singleSuccess(ClientContext context, RemoteCaller<?, T> caller, T value) throws Exception {
        Assert.assertEquals(value, (Object)caller.execute(context));
        this.checkEvents((StatelessClientContext)context, (StatelessRemoteCall)caller, true);
    }

    private void singleFailure(ClientContext context, RemoteCaller<?, ?> caller, Class<?> exceptionClass) {
        RemoteCallTestBase.setRunnerData(null);
        try {
            caller.execute(context);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertNull((Object)sSetByRunner);
            Assert.assertEquals(exceptionClass, ex.getCause().getClass());
        }
        this.checkEvents((StatelessClientContext)context, (StatelessRemoteCall)caller, false);
    }

    protected static void setRunnerData(Object value) {
        sSetByRunner = value;
    }

    private void singleSuccess(ClientContext context, RemoteRunner<?> runner, Object value) throws Exception {
        RemoteCallTestBase.setRunnerData(null);
        runner.execute(context);
        Assert.assertEquals((Object)value, (Object)sSetByRunner);
        this.checkEvents((StatelessClientContext)context, (StatelessRemoteCall)runner, true);
    }

    private void singleFailure(ClientContext context, RemoteRunner<?> runner, Class<?> exceptionClass) {
        RemoteCallTestBase.setRunnerData(null);
        try {
            runner.execute(context);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertNull((Object)sSetByRunner);
            Assert.assertEquals(exceptionClass, ex.getCause().getClass());
        }
        this.checkEvents((StatelessClientContext)context, (StatelessRemoteCall)runner, false);
    }

    protected void calls(ClientContext context, RemoteCaller<?, Integer> intCall, RemoteCaller<?, Locale> localeCall, RemoteCaller<?, ?> throwCall, RemoteCaller<?, ?> throwVersionIdCall, RemoteCaller<?, ?> throwAppIdCall, RemoteCaller<?, ?> throwClientIdCall, RemoteCaller<?, ?> throwSessionIdCall) throws Exception {
        RemoteCallTestBase.fillContext(context);
        this.singleSuccess(context, intCall, TEST_INT);
        this.singleSuccess(context, localeCall, TEST_LOCALE);
        this.singleFailure(context, throwCall, TEST_EXCEPTION.getClass());
        this.singleFailure(context, throwVersionIdCall, I18NException.class);
        this.singleFailure(context, throwAppIdCall, I18NException.class);
        this.singleFailure(context, throwClientIdCall, I18NException.class);
        this.singleFailure(context, throwSessionIdCall, I18NException.class);
        context.setVersionId(TEST_VERSION_D);
        try {
            intCall.execute(context);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertEquals((Object)new I18NBoundMessage2P(Messages.VERSION_MISMATCH, (Serializable)VersionId.SELF, (Serializable)TEST_VERSION_D), (Object)((I18NException)ex.getCause()).getI18NBoundMessage());
        }
        RemoteCallTestBase.fillContext(context);
        context.setSessionId(TEST_SESSION_D);
        try {
            intCall.execute(context);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertEquals((Object)new I18NBoundMessage1P(org.marketcetera.util.ws.tags.Messages.SESSION_EXPIRED, (Serializable)TEST_SESSION_D), (Object)((I18NException)ex.getCause()).getI18NBoundMessage());
        }
        context.setSessionId(null);
        RemoteCallTestBase.setRunnerData(null);
        throwSessionIdCall.execute(context);
        Assert.assertEquals((Object)TEST_INT, (Object)sSetByRunner);
    }

    protected void calls(ClientContext context, RemoteRunner<?> intRun, RemoteRunner<?> localeRun, RemoteRunner<?> throwRun, RemoteRunner<?> throwVersionIdRun, RemoteRunner<?> throwAppIdRun, RemoteRunner<?> throwClientIdRun, RemoteRunner<?> throwSessionIdRun) throws Exception {
        RemoteCallTestBase.fillContext(context);
        this.singleSuccess(context, intRun, TEST_INT);
        this.singleSuccess(context, localeRun, TEST_LOCALE);
        this.singleFailure(context, throwRun, TEST_EXCEPTION.getClass());
        this.singleFailure(context, throwVersionIdRun, I18NException.class);
        this.singleFailure(context, throwAppIdRun, I18NException.class);
        this.singleFailure(context, throwClientIdRun, I18NException.class);
        this.singleFailure(context, throwSessionIdRun, I18NException.class);
        context.setVersionId(TEST_VERSION_D);
        try {
            intRun.execute(context);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertEquals((Object)new I18NBoundMessage2P(Messages.VERSION_MISMATCH, (Serializable)VersionId.SELF, (Serializable)TEST_VERSION_D), (Object)((I18NException)ex.getCause()).getI18NBoundMessage());
        }
        RemoteCallTestBase.fillContext(context);
        context.setSessionId(TEST_SESSION_D);
        try {
            intRun.execute(context);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertEquals((Object)new I18NBoundMessage1P(org.marketcetera.util.ws.tags.Messages.SESSION_EXPIRED, (Serializable)TEST_SESSION_D), (Object)((I18NException)ex.getCause()).getI18NBoundMessage());
        }
        context.setSessionId(null);
        RemoteCallTestBase.setRunnerData(null);
        throwSessionIdRun.execute(context);
        Assert.assertEquals((Object)TEST_INT, (Object)sSetByRunner);
    }

    static {
        TEST_MANAGER.put(TEST_SESSION, TEST_HOLDER);
    }
}

