/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.ComparableAssert;
import org.marketcetera.util.ws.wrappers.CompSerWrapper;
import org.marketcetera.util.ws.wrappers.WrapperTestBase;

public class CompSerWrapperTest
extends WrapperTestBase {
    private static final TestComparable TEST_COMPARABLE1 = new TestComparable(1);
    private static final TestComparable TEST_COMPARABLE2 = new TestComparable(2);

    @Test
    public void all() throws Exception {
        CompSerWrapper empty = new CompSerWrapper();
        this.serialization(new CompSerWrapper((Serializable)TEST_COMPARABLE1), new CompSerWrapper((Serializable)TEST_COMPARABLE1), empty, new CompSerWrapper(null), "I am 1", TEST_COMPARABLE1, new TestUnserializableComparable(1), CompSerWrapper.class.getName());
        ComparableAssert.assertComparable((Comparable)TEST_COMPARABLE1, (Comparable)new TestComparable(1), (Comparable)TEST_COMPARABLE2);
        CompSerWrapper w1 = new CompSerWrapper((Serializable)TEST_COMPARABLE1);
        ComparableAssert.assertComparable((Comparable)w1, (Comparable)new CompSerWrapper((Serializable)TEST_COMPARABLE1), (Comparable)new CompSerWrapper((Serializable)TEST_COMPARABLE2), (String)"Argument is null");
        try {
            empty.compareTo(w1);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"Receiver wraps a null value", (Object)ex.getMessage());
        }
        try {
            w1.compareTo(empty);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"Argument wraps a null value", (Object)ex.getMessage());
        }
    }

    private static class TestUnserializableComparable
    extends TestComparable {
        private static final long serialVersionUID = 1L;

        public TestUnserializableComparable(int value) {
            super(value);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException();
        }
    }

    private static class TestComparable
    extends WrapperTestBase.TestInteger
    implements Comparable<TestComparable> {
        private static final long serialVersionUID = 1L;

        public TestComparable(int value) {
            super(value);
        }

        @Override
        public int compareTo(TestComparable other) {
            if (other == null) {
                throw new NullPointerException();
            }
            return this.getValue() - other.getValue();
        }
    }
}

