/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.Serializable;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.test.EqualityAssert;
import org.marketcetera.util.ws.wrappers.RemoteI18NBoundMessage;
import org.marketcetera.util.ws.wrappers.SerWrapper;
import org.marketcetera.util.ws.wrappers.TestMessages;
import org.marketcetera.util.ws.wrappers.WrapperTestBase;

public class RemoteI18NBoundMessageTest
extends WrapperTestBase {
    private static final String EXPECTED_MESSAGE = "Bound message text is 'testMessage'";
    private static final String EXPECTED_MESSAGE_FR = "Bound message text in French is 'testMessage'";
    private static final String EXPECTED_NONSER_MESSAGE = "Bound message text is 'I am 1'";
    private static final String EXPECTED_NONSER_MESSAGE_FR = "Bound message text in French is 'I am 1'";
    private static final String EXPECTED_NONDESER_MESSAGE = "provider 'nonexistent_prv'; id 'any'; entry 'msg'; parameters ()";

    private void singleBase(RemoteI18NBoundMessage m, SerWrapper<I18NBoundMessage> wrapper, boolean wrapperSerFailure, boolean wrapperDeSerFailure, String string, String text, String textFr) {
        Assert.assertEquals(wrapper, (Object)m.getWrapper());
        if (wrapperSerFailure) {
            this.assertSerWrapperSerFailure(m.getWrapper());
        } else if (m.getWrapper() != null) {
            Assert.assertNull((Object)m.getWrapper().getSerializationException());
        }
        if (wrapperDeSerFailure) {
            this.assertSerWrapperDeSerFailure(m.getWrapper());
        } else if (m.getWrapper() != null) {
            Assert.assertNull((Object)m.getWrapper().getDeserializationException());
        }
        Assert.assertEquals((Object)string, (Object)m.getString());
        Assert.assertEquals((Object)text, (Object)m.getText());
        Assert.assertEquals((Object)text, (Object)m.toString());
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertEquals((Object)textFr, (Object)m.getText());
        Assert.assertEquals((Object)textFr, (Object)m.toString());
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
    }

    private void singleNonSerializable(RemoteI18NBoundMessage server, RemoteI18NBoundMessage client) {
        this.singleBase(client, (SerWrapper<I18NBoundMessage>)server.getWrapper(), false, false, server.getString(), server.getText(), server.getText());
    }

    private void singleNonDeserializable(RemoteI18NBoundMessage server, RemoteI18NBoundMessage client) {
        this.singleBase(client, (SerWrapper<I18NBoundMessage>)new SerWrapper(), false, true, server.getString(), server.getText(), server.getText());
    }

    private void single(RemoteI18NBoundMessage server, SerWrapper<I18NBoundMessage> wrapper, String string, String text, String textFr) throws Exception {
        this.singleBase(server, wrapper, false, false, string, text, textFr);
        this.singleBase(this.assertRoundTripJAXB(server), wrapper, false, false, string, text, textFr);
        this.singleBase(this.assertRoundTripJava(server), wrapper, false, false, string, text, textFr);
    }

    @Test
    public void basics() throws Exception {
        EqualityAssert.assertEquality((Object)new RemoteI18NBoundMessage(null), (Object)new RemoteI18NBoundMessage(null), (Object[])new Object[]{new RemoteI18NBoundMessage((I18NBoundMessage)TEST_I18N_MESSAGE)});
        this.single(new RemoteI18NBoundMessage(null), null, null, null, null);
        EqualityAssert.assertEquality((Object)new RemoteI18NBoundMessage((I18NBoundMessage)TEST_I18N_MESSAGE), (Object)new RemoteI18NBoundMessage((I18NBoundMessage)TEST_I18N_MESSAGE), (Object[])new Object[]{new RemoteI18NBoundMessage(null), new RemoteI18NBoundMessage((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.BOUND, (Serializable)((Object)"testMessaged")))});
        this.single(new RemoteI18NBoundMessage((I18NBoundMessage)TEST_I18N_MESSAGE), (SerWrapper<I18NBoundMessage>)new SerWrapper((Serializable)TEST_I18N_MESSAGE), EXPECTED_MESSAGE, EXPECTED_MESSAGE, EXPECTED_MESSAGE_FR);
    }

    @Test
    public void setters() {
        RemoteI18NBoundMessage m = new RemoteI18NBoundMessage((I18NBoundMessage)TEST_I18N_MESSAGE);
        SerWrapper wrapper = new SerWrapper();
        m.setWrapper(wrapper);
        Assert.assertEquals((Object)wrapper, (Object)m.getWrapper());
        m.setString("testMessage");
        Assert.assertEquals((Object)"testMessage", (Object)m.getString());
        m.setWrapper(null);
        Assert.assertNull((Object)m.getWrapper());
        m.setString(null);
        Assert.assertNull((Object)m.getString());
    }

    @Test
    public void nonSerializableThrowable() throws Exception {
        this.prepareSerWrapperFailure();
        RemoteI18NBoundMessage server = new RemoteI18NBoundMessage((I18NBoundMessage)TEST_NONSER_MESSAGE);
        EqualityAssert.assertEquality((Object)server, (Object)new RemoteI18NBoundMessage((I18NBoundMessage)TEST_NONSER_MESSAGE), (Object[])new Object[]{new RemoteI18NBoundMessage(null), new RemoteI18NBoundMessage((I18NBoundMessage)TEST_I18N_MESSAGE)});
        this.singleBase(server, (SerWrapper<I18NBoundMessage>)new SerWrapper(), true, false, EXPECTED_NONSER_MESSAGE, EXPECTED_NONSER_MESSAGE, EXPECTED_NONSER_MESSAGE_FR);
        this.singleNonSerializable(server, this.assertRoundTripJAXB(server));
        this.singleNonSerializable(server, this.assertRoundTripJava(server));
    }

    @Test
    public void nonDeserializableThrowable() throws Exception {
        RemoteI18NBoundMessage server = new RemoteI18NBoundMessage((I18NBoundMessage)TEST_NONDESER_MESSAGE);
        EqualityAssert.assertEquality((Object)server, (Object)new RemoteI18NBoundMessage((I18NBoundMessage)TEST_NONDESER_MESSAGE), (Object[])new Object[]{new RemoteI18NBoundMessage(null), new RemoteI18NBoundMessage((I18NBoundMessage)TEST_I18N_MESSAGE)});
        this.singleBase(server, (SerWrapper<I18NBoundMessage>)new SerWrapper((Serializable)TEST_NONDESER_MESSAGE), false, false, EXPECTED_NONDESER_MESSAGE, EXPECTED_NONDESER_MESSAGE, EXPECTED_NONDESER_MESSAGE);
        this.singleNonDeserializable(server, this.assertRoundTripJAXB(server));
        this.singleNonDeserializable(server, this.assertRoundTripJava(server));
    }
}

