/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.test.EqualityAssert;
import org.marketcetera.util.test.RegExAssert;
import org.marketcetera.util.ws.wrappers.RemoteProperties;
import org.marketcetera.util.ws.wrappers.SerWrapper;
import org.marketcetera.util.ws.wrappers.WrapperTestBase;

public class RemotePropertiesTest
extends WrapperTestBase {
    private static final String[] TEST_TRACE = new String[]{"testTrace"};
    private static final String TEST_STRING = "testString";
    private static final String TEST_CLASS = "testClass";

    private void singleBase(RemoteProperties p, SerWrapper<Throwable> wrapper, boolean wrapperSerFailure, boolean wrapperDeSerFailure, String serverMessage, String serverString, String serverName, Throwable throwable, boolean proxyUsed) {
        Assert.assertEquals(wrapper, (Object)p.getWrapper());
        if (wrapperSerFailure) {
            this.assertSerWrapperSerFailure(p.getWrapper());
        } else if (p.getWrapper() != null) {
            Assert.assertNull((Object)p.getWrapper().getSerializationException());
        }
        if (wrapperDeSerFailure) {
            this.assertSerWrapperDeSerFailure(p.getWrapper());
        } else if (p.getWrapper() != null) {
            Assert.assertNull((Object)p.getWrapper().getDeserializationException());
        }
        Assert.assertEquals((Object)serverMessage, (Object)p.getServerMessage());
        Assert.assertEquals((Object)serverString, (Object)p.getServerString());
        Assert.assertEquals((Object)serverName, (Object)p.getServerName());
        if (serverString == null) {
            Assert.assertNull((Object)p.getTraceCapture());
        } else {
            Assert.assertEquals((Object)serverString, (Object)p.getTraceCapture()[0]);
            RegExAssert.assertMatches((String)("\\s*at\\s*" + WrapperTestBase.class.getName().replace(".", "\\.") + ".*"), (String)p.getTraceCapture()[1]);
        }
        RemotePropertiesTest.assertThrowable(throwable, p.getThrowable(), proxyUsed);
    }

    private void singleNonSerializable(RemoteProperties server, RemoteProperties client) {
        this.singleBase(client, (SerWrapper<Throwable>)server.getWrapper(), false, false, server.getServerMessage(), server.getServerString(), server.getServerName(), server.getThrowable(), true);
    }

    private void singleNonDeserializable(RemoteProperties server, RemoteProperties client) {
        this.singleBase(client, (SerWrapper<Throwable>)new SerWrapper(), false, true, server.getServerMessage(), server.getServerString(), server.getServerName(), server.getThrowable(), true);
    }

    private void single(RemoteProperties server, SerWrapper<Throwable> wrapper, String serverMessage, String serverString, String serverName, Throwable throwable) throws Exception {
        this.singleBase(server, wrapper, false, false, serverMessage, serverString, serverName, throwable, false);
        this.singleBase(this.assertRoundTripJAXB(server), wrapper, false, false, serverMessage, serverString, serverName, throwable, false);
        this.singleBase(this.assertRoundTripJava(server), wrapper, false, false, serverMessage, serverString, serverName, throwable, false);
    }

    @Test
    public void basics() throws Exception {
        EqualityAssert.assertEquality((Object)new RemoteProperties(), (Object)new RemoteProperties(), (Object[])new Object[]{new RemoteProperties(TEST_THROWABLE), new RemoteProperties((Throwable)TEST_I18N_THROWABLE)});
        this.single(new RemoteProperties(), null, null, null, null, null);
        EqualityAssert.assertEquality((Object)new RemoteProperties(null), (Object)new RemoteProperties(null), (Object[])new Object[]{new RemoteProperties(TEST_THROWABLE), new RemoteProperties((Throwable)TEST_I18N_THROWABLE)});
        this.single(new RemoteProperties(null), null, null, null, null, null);
        Assert.assertEquals((Object)new RemoteProperties(), (Object)new RemoteProperties(null));
        EqualityAssert.assertEquality((Object)new RemoteProperties(TEST_THROWABLE), (Object)new RemoteProperties(TEST_THROWABLE), (Object[])new Object[]{new RemoteProperties(), new RemoteProperties(null), new RemoteProperties((Throwable)TEST_I18N_THROWABLE)});
        this.single(new RemoteProperties(TEST_THROWABLE), (SerWrapper<Throwable>)new SerWrapper((Serializable)TEST_THROWABLE), TEST_THROWABLE.getLocalizedMessage(), WrapperTestBase.TestThrowable.class.getName() + ": " + "testMessage", WrapperTestBase.TestThrowable.class.getName(), TEST_THROWABLE);
        EqualityAssert.assertEquality((Object)new RemoteProperties((Throwable)TEST_I18N_THROWABLE), (Object)new RemoteProperties((Throwable)TEST_I18N_THROWABLE), (Object[])new Object[]{new RemoteProperties(), new RemoteProperties(null), new RemoteProperties(TEST_THROWABLE)});
        this.single(new RemoteProperties((Throwable)TEST_I18N_THROWABLE), (SerWrapper<Throwable>)new SerWrapper((Serializable)TEST_I18N_THROWABLE), TEST_I18N_THROWABLE.getLocalizedDetail(), I18NException.class.getName() + ": " + TEST_I18N_THROWABLE.getLocalizedMessage(), I18NException.class.getName(), (Throwable)TEST_I18N_THROWABLE);
    }

    @Test
    public void setters() {
        RemoteProperties p = new RemoteProperties();
        SerWrapper wrapper = new SerWrapper();
        p.setWrapper(wrapper);
        Assert.assertEquals((Object)wrapper, (Object)p.getWrapper());
        p.setTraceCapture(TEST_TRACE);
        Assert.assertArrayEquals((Object[])TEST_TRACE, (Object[])p.getTraceCapture());
        p.setServerMessage("testMessage");
        Assert.assertEquals((Object)"testMessage", (Object)p.getServerMessage());
        p.setServerString(TEST_STRING);
        Assert.assertEquals((Object)TEST_STRING, (Object)p.getServerString());
        p.setServerName(TEST_CLASS);
        Assert.assertEquals((Object)TEST_CLASS, (Object)p.getServerName());
        p.setWrapper(null);
        Assert.assertNull((Object)p.getWrapper());
        p.setTraceCapture(null);
        Assert.assertNull((Object)p.getTraceCapture());
        p.setServerMessage(null);
        Assert.assertNull((Object)p.getServerMessage());
        p.setServerString(null);
        Assert.assertNull((Object)p.getServerString());
        p.setServerName(null);
        Assert.assertNull((Object)p.getServerName());
    }

    @Test
    public void nonSerializableThrowable() throws Exception {
        this.prepareSerWrapperFailure();
        RemoteProperties server = new RemoteProperties(TEST_NONSER_THROWABLE);
        EqualityAssert.assertEquality((Object)server, (Object)new RemoteProperties(TEST_NONSER_THROWABLE), (Object[])new Object[]{new RemoteProperties(), new RemoteProperties(null), new RemoteProperties(TEST_THROWABLE), new RemoteProperties((Throwable)TEST_I18N_THROWABLE)});
        this.singleBase(server, (SerWrapper<Throwable>)new SerWrapper(), true, false, TEST_NONSER_THROWABLE.getLocalizedMessage(), WrapperTestBase.TestUnserializableThrowable.class.getName() + ": " + "testMessage", WrapperTestBase.TestUnserializableThrowable.class.getName(), TEST_NONSER_THROWABLE, false);
        this.singleNonSerializable(server, this.assertRoundTripJAXB(server));
        this.singleNonSerializable(server, this.assertRoundTripJava(server));
    }

    @Test
    public void nonDeserializableThrowable() throws Exception {
        RemoteProperties server = new RemoteProperties((Throwable)TEST_NONDESER_THROWABLE);
        EqualityAssert.assertEquality((Object)server, (Object)new RemoteProperties((Throwable)TEST_NONDESER_THROWABLE), (Object[])new Object[]{new RemoteProperties(), new RemoteProperties(null), new RemoteProperties(TEST_THROWABLE), new RemoteProperties((Throwable)TEST_I18N_THROWABLE), new RemoteProperties(TEST_NONSER_THROWABLE)});
        this.singleBase(server, (SerWrapper<Throwable>)new SerWrapper((Serializable)TEST_NONDESER_THROWABLE), false, false, TEST_NONDESER_THROWABLE.getLocalizedDetail(), I18NException.class.getName() + ": " + TEST_NONDESER_THROWABLE.getLocalizedMessage(), I18NException.class.getName(), (Throwable)TEST_NONDESER_THROWABLE, false);
        this.singleNonDeserializable(server, this.assertRoundTripJAXB(server));
        this.singleNonDeserializable(server, this.assertRoundTripJava(server));
    }
}

