/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.marketcetera.util.exec.Messages;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: InputThread.java 16154 2012-07-14 16:34:05Z colin $")
class InputThread
extends Thread {
    private String mCommand;
    private InputStream mIn;
    private OutputStream mOut;
    private boolean mCloseOut;

    InputThread(String command, InputStream in, OutputStream out, boolean closeOut) {
        super(command);
        this.setDaemon(true);
        this.mCommand = command;
        this.mIn = in;
        this.mOut = out;
        this.mCloseOut = closeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CloseableRegistry r = new CloseableRegistry();
        r.register(this.mIn);
        if (this.mCloseOut) {
            r.register(this.mOut);
        }
        try {
            IOUtils.copyLarge((InputStream)this.mIn, (OutputStream)this.mOut);
        }
        catch (IOException ex) {
            Messages.CANNOT_COPY_OUTPUT.error(this, ex, this.mCommand);
        }
        finally {
            r.close();
        }
    }
}

