/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.marketcetera.util.file.Messages;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: FileType.java 16154 2012-07-14 16:34:05Z colin $")
public enum FileType {
    NONEXISTENT,
    LINK_FILE,
    FILE,
    LINK_DIR,
    DIR,
    LINK_UNKNOWN,
    UNKNOWN;


    public static final FileType get(File file) {
        if (file == null) {
            return UNKNOWN;
        }
        try {
            File absFile = file.getAbsoluteFile();
            if (absFile == null) {
                return UNKNOWN;
            }
            File parent = absFile.getParentFile();
            if (!file.exists()) {
                String[] children;
                if (parent != null && (children = parent.list()) != null && Arrays.asList(children).contains(file.getName())) {
                    return LINK_UNKNOWN;
                }
                return NONEXISTENT;
            }
            if (parent != null) {
                File pCanFile = parent.getCanonicalFile();
                if (pCanFile == null) {
                    return UNKNOWN;
                }
                file = new File(pCanFile, file.getName());
            }
            absFile = file.getAbsoluteFile();
            File canFile = file.getCanonicalFile();
            if (canFile == null || absFile == null) {
                return UNKNOWN;
            }
            if (canFile.equals(absFile)) {
                if (file.isDirectory()) {
                    return DIR;
                }
                if (file.isFile()) {
                    return FILE;
                }
            } else {
                if (file.isDirectory()) {
                    return LINK_DIR;
                }
                if (file.isFile()) {
                    return LINK_FILE;
                }
            }
        }
        catch (IOException ex) {
            Messages.CANNOT_GET_TYPE.warn(FileType.class, ex, file.getAbsolutePath());
        }
        return UNKNOWN;
    }

    public static final FileType get(String name) {
        if (name == null) {
            return UNKNOWN;
        }
        return FileType.get(new File(name));
    }

    public boolean isSymbolicLink() {
        return this == LINK_FILE || this == LINK_DIR || this == LINK_UNKNOWN;
    }

    public boolean isDirectory() {
        return this == LINK_DIR || this == DIR;
    }

    public boolean isFile() {
        return this == LINK_FILE || this == FILE;
    }
}

