/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.l10n;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.l10n.I18NMessageInfo;
import org.marketcetera.util.l10n.MessageInfo;
import org.marketcetera.util.l10n.MessageInfoProvider;
import org.marketcetera.util.l10n.Messages;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessageProvider;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.misc.ReflectUtils;

@ClassVersion(value="$Id: ContainerClassInfo.java 16154 2012-07-14 16:34:05Z colin $")
public class ContainerClassInfo
implements MessageInfoProvider {
    private Class<?> mContainer;
    private I18NMessageProvider mProvider;
    private List<MessageInfo> mMessageInfo;

    public ContainerClassInfo(Class<?> container) throws I18NException {
        this.mContainer = container;
        this.mMessageInfo = new LinkedList<MessageInfo>();
        try {
            for (Field field : ReflectUtils.getAllFields(this.getContainer())) {
                String name = field.getName();
                if ((field.getModifiers() & 8) == 0) {
                    Messages.NONSTATIC_FIELD_IGNORED.info(this, name);
                    continue;
                }
                Class<?> type = field.getType();
                if (I18NMessage.class.isAssignableFrom(type)) {
                    field.setAccessible(true);
                    I18NMessage message = (I18NMessage)field.get(this.getContainer());
                    if (message == null) {
                        Messages.NULL_FIELD_IGNORED.info(this, name);
                        continue;
                    }
                    this.addMessage(message);
                }
                if (!I18NMessageProvider.class.isAssignableFrom(type)) continue;
                this.setProvider((I18NMessageProvider)field.get(this.getContainer()));
            }
        }
        catch (IllegalAccessException ex) {
            throw new I18NException(ex, new I18NBoundMessage1P(Messages.INTROSPECTION_FAILED, (Serializable)((Object)this.getContainer().getName())));
        }
        if (this.getProvider() == null) {
            throw new I18NException(new I18NBoundMessage1P(Messages.MISSING_PROVIDER, (Serializable)((Object)this.getContainer().getName())));
        }
    }

    protected void addMessage(I18NMessage message) throws I18NException {
        this.setProvider(message.getMessageProvider());
        this.mMessageInfo.add(new I18NMessageInfo(message.getMessageId() + "." + message.getEntryId(), message.getParamCount(), message));
    }

    public Class<?> getContainer() {
        return this.mContainer;
    }

    private void setProvider(I18NMessageProvider provider) throws I18NException {
        if (this.getProvider() != null && !this.getProvider().equals(provider)) {
            throw new I18NException(new I18NBoundMessage3P(Messages.MULTIPLE_PROVIDERS, (Serializable)((Object)this.getContainer().getName()), (Serializable)((Object)this.getProvider().getProviderId()), (Serializable)((Object)provider.getProviderId())));
        }
        this.mProvider = provider;
    }

    public I18NMessageProvider getProvider() {
        return this.mProvider;
    }

    @Override
    public List<MessageInfo> getMessageInfo() {
        return this.mMessageInfo;
    }
}

