/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessageProvider;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: I18NLoggerProxy.java 16154 2012-07-14 16:34:05Z colin $")
public class I18NLoggerProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SELF_PROXY = I18NLoggerProxy.class.getName();
    private I18NMessageProvider mMessageProvider;

    public I18NLoggerProxy(I18NMessageProvider messageProvider) {
        this.mMessageProvider = messageProvider;
    }

    public I18NMessageProvider getMessageProvider() {
        return this.mMessageProvider;
    }

    void errorProxy(String proxy, Object category, Throwable throwable) {
        if (!SLF4JLoggerProxy.isErrorEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.errorProxy(proxy, category, throwable);
    }

    public void error(Object category, Throwable throwable) {
        this.errorProxy(SELF_PROXY, category, throwable);
    }

    void errorProxy(String proxy, Object category, Throwable throwable, I18NMessage message, Object ... params) {
        if (!SLF4JLoggerProxy.isErrorEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.errorProxy(proxy, category, this.getMessageProvider().getText(message, params), throwable);
    }

    public void error(Object category, Throwable throwable, I18NMessage message, Object ... params) {
        this.errorProxy(SELF_PROXY, category, throwable, message, params);
    }

    void errorProxy(String proxy, Object category, I18NMessage message, Object ... params) {
        if (!SLF4JLoggerProxy.isErrorEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.errorProxy(proxy, category, this.getMessageProvider().getText(message, params));
    }

    public void error(Object category, I18NMessage message, Object ... params) {
        this.errorProxy(SELF_PROXY, category, message, params);
    }

    void warnProxy(String proxy, Object category, Throwable throwable) {
        if (!SLF4JLoggerProxy.isWarnEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.warnProxy(proxy, category, throwable);
    }

    public void warn(Object category, Throwable throwable) {
        this.warnProxy(SELF_PROXY, category, throwable);
    }

    void warnProxy(String proxy, Object category, Throwable throwable, I18NMessage message, Object ... params) {
        if (!SLF4JLoggerProxy.isWarnEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.warnProxy(proxy, category, this.getMessageProvider().getText(message, params), throwable);
    }

    public void warn(Object category, Throwable throwable, I18NMessage message, Object ... params) {
        this.warnProxy(SELF_PROXY, category, throwable, message, params);
    }

    void warnProxy(String proxy, Object category, I18NMessage message, Object ... params) {
        if (!SLF4JLoggerProxy.isWarnEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.warnProxy(proxy, category, this.getMessageProvider().getText(message, params));
    }

    public void warn(Object category, I18NMessage message, Object ... params) {
        this.warnProxy(SELF_PROXY, category, message, params);
    }

    void infoProxy(String proxy, Object category, Throwable throwable) {
        if (!SLF4JLoggerProxy.isInfoEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.infoProxy(proxy, category, throwable);
    }

    public void info(Object category, Throwable throwable) {
        this.infoProxy(SELF_PROXY, category, throwable);
    }

    void infoProxy(String proxy, Object category, Throwable throwable, I18NMessage message, Object ... params) {
        if (!SLF4JLoggerProxy.isInfoEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.infoProxy(proxy, category, this.getMessageProvider().getText(message, params), throwable);
    }

    public void info(Object category, Throwable throwable, I18NMessage message, Object ... params) {
        this.infoProxy(SELF_PROXY, category, throwable, message, params);
    }

    void infoProxy(String proxy, Object category, I18NMessage message, Object ... params) {
        if (!SLF4JLoggerProxy.isInfoEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.infoProxy(proxy, category, this.getMessageProvider().getText(message, params));
    }

    public void info(Object category, I18NMessage message, Object ... params) {
        this.infoProxy(SELF_PROXY, category, message, params);
    }

    void debugProxy(String proxy, Object category, Throwable throwable) {
        if (!SLF4JLoggerProxy.isDebugEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.debugProxy(proxy, category, throwable);
    }

    public void debug(Object category, Throwable throwable) {
        this.debugProxy(SELF_PROXY, category, throwable);
    }

    void debugProxy(String proxy, Object category, Throwable throwable, I18NMessage message, Object ... params) {
        if (!SLF4JLoggerProxy.isDebugEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.debugProxy(proxy, category, this.getMessageProvider().getText(message, params), throwable);
    }

    public void debug(Object category, Throwable throwable, I18NMessage message, Object ... params) {
        this.debugProxy(SELF_PROXY, category, throwable, message, params);
    }

    void debugProxy(String proxy, Object category, I18NMessage message, Object ... params) {
        if (!SLF4JLoggerProxy.isDebugEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.debugProxy(proxy, category, this.getMessageProvider().getText(message, params));
    }

    public void debug(Object category, I18NMessage message, Object ... params) {
        this.debugProxy(SELF_PROXY, category, message, params);
    }

    void traceProxy(String proxy, Object category, Throwable throwable) {
        if (!SLF4JLoggerProxy.isTraceEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.traceProxy(proxy, category, throwable);
    }

    public void trace(Object category, Throwable throwable) {
        this.traceProxy(SELF_PROXY, category, throwable);
    }

    void traceProxy(String proxy, Object category, Throwable throwable, I18NMessage message, Object ... params) {
        if (!SLF4JLoggerProxy.isTraceEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.traceProxy(proxy, category, this.getMessageProvider().getText(message, params), throwable);
    }

    public void trace(Object category, Throwable throwable, I18NMessage message, Object ... params) {
        this.traceProxy(SELF_PROXY, category, throwable, message, params);
    }

    void traceProxy(String proxy, Object category, I18NMessage message, Object ... params) {
        if (!SLF4JLoggerProxy.isTraceEnabled(category)) {
            return;
        }
        SLF4JLoggerProxy.traceProxy(proxy, category, this.getMessageProvider().getText(message, params));
    }

    public void trace(Object category, I18NMessage message, Object ... params) {
        this.traceProxy(SELF_PROXY, category, message, params);
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.getMessageProvider());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        I18NLoggerProxy o = (I18NLoggerProxy)other;
        return ObjectUtils.equals((Object)this.getMessageProvider(), (Object)o.getMessageProvider());
    }
}

