/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessageProvider;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: LogUtils.java 16154 2012-07-14 16:34:05Z colin $")
public final class LogUtils {
    public static String getListText(Object ... list) {
        if (list == null) {
            list = new Object[]{null};
        }
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        boolean first = true;
        for (Object e : list) {
            if (!first) {
                builder.append(',');
            }
            if (e == null) {
                builder.append("[null]");
            } else {
                builder.append('\'');
                builder.append(e.toString());
                builder.append('\'');
            }
            first = false;
        }
        builder.append(')');
        return builder.toString();
    }

    public static String getSimpleMessage(I18NMessageProvider provider, I18NMessage message, Object ... params) {
        return "provider '" + provider.getProviderId() + "'; id '" + message.getMessageId() + "'; entry '" + message.getEntryId() + "'; parameters " + LogUtils.getListText(params);
    }

    public static String getSimpleMessage(I18NMessage message, Object ... params) {
        return LogUtils.getSimpleMessage(message.getMessageProvider(), message, params);
    }

    public static String getSimpleMessage(I18NBoundMessage message) {
        return LogUtils.getSimpleMessage(message.getMessage(), message.getParamsAsObjects());
    }

    private LogUtils() {
    }
}

