/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: NamedThreadFactory.java 16154 2012-07-14 16:34:05Z colin $")
public class NamedThreadFactory
implements ThreadFactory {
    private final String mNamePrefix;
    private final AtomicInteger mThreadNumber = new AtomicInteger(1);
    private final ThreadFactory mDelegate;

    public NamedThreadFactory(String inNamePrefix) {
        if (inNamePrefix == null) {
            throw new NullPointerException();
        }
        this.mNamePrefix = inNamePrefix;
        this.mDelegate = Executors.defaultThreadFactory();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = this.mDelegate.newThread(r);
        t.setName(this.mNamePrefix + this.mThreadNumber.getAndIncrement());
        return t;
    }
}

