/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.quickfix;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.quickfix.AnalyzedGroup;
import org.marketcetera.util.quickfix.Messages;
import quickfix.DataDictionary;
import quickfix.Field;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.FieldType;
import quickfix.Group;

@ClassVersion(value="$Id: AnalyzedField.java 17411 2017-04-28 14:50:38Z colin $")
public class AnalyzedField {
    private final Field<?> mQField;
    private final FieldType mQType;
    private final String mName;
    private final boolean mRequired;
    private final String mValue;
    private final List<AnalyzedGroup> mGroups = new LinkedList<AnalyzedGroup>();

    AnalyzedField(DataDictionary nameQDict, DataDictionary scopeQDict, FieldMap qMap, String msgType, Field<?> qField) {
        this.mQField = qField;
        this.mQType = nameQDict.getFieldType(this.getQFieldTag());
        this.mName = nameQDict.getFieldName(this.getQFieldTag());
        this.mRequired = scopeQDict.isRequiredField(msgType, this.getQFieldTag());
        String value = this.getQFieldValueAsString();
        this.mValue = nameQDict.hasFieldValue(this.getQFieldTag()) ? (nameQDict.isFieldValue(this.getQFieldTag(), value) ? Messages.ENUM_FIELD_VALUE.getText(value, nameQDict.getValueName(this.getQFieldTag(), value)) : Messages.INVALID_FIELD_VALUE.getText(value)) : value;
        DataDictionary.GroupInfo info = scopeQDict.getGroup(msgType, this.getQFieldTag());
        if (info == null) {
            return;
        }
        int count = Integer.valueOf(value);
        for (int i = 0; i < count; ++i) {
            Group group = new Group(this.getQFieldTag(), info.getDelimiterField());
            try {
                qMap.getGroup(i + 1, group);
            }
            catch (FieldNotFound ex) {
                Messages.MISSING_GROUP.error(this, ex, i + 1, qMap);
                continue;
            }
            this.mGroups.add(new AnalyzedGroup(nameQDict, info.getDataDictionary(), group, msgType));
        }
    }

    public Field<?> getQField() {
        return this.mQField;
    }

    public FieldType getQType() {
        return this.mQType;
    }

    public String getName() {
        return this.mName;
    }

    public boolean getRequired() {
        return this.mRequired;
    }

    public String getValue() {
        return this.mValue;
    }

    public List<AnalyzedGroup> getGroups() {
        return this.mGroups;
    }

    public int getQFieldTag() {
        return this.getQField().getTag();
    }

    public Object getQFieldValue() {
        return this.getQField().getObject();
    }

    public String getQFieldValueAsString() {
        return ObjectUtils.toString((Object)this.getQFieldValue(), null);
    }

    public void print(PrintStream stream, String prefix) {
        stream.print(prefix);
        stream.print(Messages.SINGLE_FIELD.getText(this.getName(), this.getQFieldTag(), this.getValue(), this.getRequired() ? 1 : 0));
        prefix = prefix + ' ';
        String groupPrefix = prefix + ' ';
        int i = 0;
        for (AnalyzedGroup group : this.getGroups()) {
            stream.println();
            stream.print(prefix);
            stream.print(Messages.GROUP_TITLE.getText(++i));
            group.print(stream, groupPrefix);
        }
    }
}

