/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.quickfix;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.misc.ReflectUtils;
import org.marketcetera.util.quickfix.Messages;
import org.marketcetera.util.quickfix.SpringSessionDescriptor;
import org.marketcetera.util.spring.LazyBean;
import quickfix.ConfigError;
import quickfix.FileStoreFactory;
import quickfix.LogFactory;
import quickfix.MessageStoreFactory;
import quickfix.SLF4JLogFactory;
import quickfix.SessionSettings;

@ClassVersion(value="$Id: SpringSessionSettings.java 17411 2017-04-28 14:50:38Z colin $")
public class SpringSessionSettings
extends LazyBean {
    public static final String LOG_FACTORY_CLASS_PARAM = "metc.LogFactoryClass";
    public static final String MESSAGE_STORE_FACTORY_CLASS_PARAM = "metc.MessageStoreFactoryClass";
    private Map<Object, Object> mDefaults;
    private List<SpringSessionDescriptor> mDescriptors;
    private SessionSettings mQSettings;
    private LogFactory mQLogFactory;
    private MessageStoreFactory mQMessageStoreFactory;

    public void setDefaults(Map<Object, Object> defaults) {
        this.assertNotProcessed();
        this.mDefaults = defaults;
    }

    public Map<Object, Object> getDefaults() {
        return this.mDefaults;
    }

    public void setDescriptors(List<SpringSessionDescriptor> descriptors) {
        this.assertNotProcessed();
        this.mDescriptors = descriptors;
        if (this.getDescriptors() != null) {
            for (SpringSessionDescriptor descriptor : this.getDescriptors()) {
                descriptor.setSettings(this);
            }
        }
    }

    public List<SpringSessionDescriptor> getDescriptors() {
        return this.mDescriptors;
    }

    public SessionSettings getQSettings() {
        this.ensureProcessed();
        return this.mQSettings;
    }

    public LogFactory getQLogFactory() {
        this.ensureProcessed();
        return this.mQLogFactory;
    }

    public MessageStoreFactory getQMessageStoreFactory() {
        this.ensureProcessed();
        return this.mQMessageStoreFactory;
    }

    @Override
    protected void process() {
        String logFactoryClass = null;
        String messageStoreFactoryClass = null;
        this.mQSettings = new SessionSettings();
        if (this.getDefaults() != null) {
            HashMap<Object, Object> defaults = new HashMap<Object, Object>(this.getDefaults());
            logFactoryClass = (String)this.getDefaults().get(LOG_FACTORY_CLASS_PARAM);
            defaults.remove(LOG_FACTORY_CLASS_PARAM);
            messageStoreFactoryClass = (String)this.getDefaults().get(MESSAGE_STORE_FACTORY_CLASS_PARAM);
            defaults.remove(MESSAGE_STORE_FACTORY_CLASS_PARAM);
            this.mQSettings.set(defaults);
        }
        if (this.getDescriptors() != null) {
            for (SpringSessionDescriptor descriptor : this.getDescriptors()) {
                try {
                    this.mQSettings.set(descriptor.getQSessionID(), descriptor.getQDictionary());
                }
                catch (ConfigError ex) {
                    throw new I18NRuntimeException(ex, Messages.CONFIG_ERROR);
                }
            }
        }
        if (logFactoryClass == null) {
            this.mQLogFactory = new SLF4JLogFactory(this.mQSettings);
        } else {
            try {
                this.mQLogFactory = (LogFactory)ReflectUtils.getInstance(logFactoryClass, new Class[]{this.mQSettings.getClass()}, new Object[]{this.mQSettings});
            }
            catch (Exception ex) {
                ExceptUtils.interrupt(ex);
                throw new I18NRuntimeException(ex, new I18NBoundMessage1P(Messages.BAD_LOG_FACTORY, (Serializable)((Object)logFactoryClass)));
            }
        }
        if (messageStoreFactoryClass == null) {
            this.mQMessageStoreFactory = new FileStoreFactory(this.mQSettings);
        } else {
            try {
                this.mQMessageStoreFactory = (MessageStoreFactory)ReflectUtils.getInstance(messageStoreFactoryClass, new Class[]{this.mQSettings.getClass()}, new Object[]{this.mQSettings});
            }
            catch (Exception ex) {
                ExceptUtils.interrupt(ex);
                throw new I18NRuntimeException(ex, new I18NBoundMessage1P(Messages.BAD_MESSAGE_STORE_FACTORY, (Serializable)((Object)messageStoreFactoryClass)));
            }
        }
    }
}

