/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.rpc;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.util.Locale;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.rpc.BaseRpc;
import org.marketcetera.util.rpc.RpcCredentials;
import org.marketcetera.util.rpc.RpcServerServices;
import org.marketcetera.util.rpc.RpcServiceSpec;
import org.marketcetera.util.ws.tags.SessionId;

public abstract class BaseRpcService<SessionClazz>
implements RpcServiceSpec<SessionClazz>,
BaseRpc.BaseRpcService.BlockingInterface {
    private RpcServerServices<SessionClazz> serverServices;

    @Override
    public BaseRpc.LoginResponse login(RpcController inController, BaseRpc.LoginRequest inRequest) throws ServiceException {
        SLF4JLoggerProxy.trace((Object)this, "{} received authentication request for {}", this.getDescription(), inRequest.getUsername());
        BaseRpc.LoginResponse.Builder responseBuilder = BaseRpc.LoginResponse.newBuilder();
        BaseRpc.Status.Builder statusBuilder = BaseRpc.Status.newBuilder();
        statusBuilder.setFailed(false);
        try {
            SessionId sessionId = this.serverServices.login(new RpcCredentials(inRequest.getUsername(), inRequest.getPassword(), inRequest.getAppId(), inRequest.getClientId(), inRequest.getVersionId(), new Locale(inRequest.getLocale().getLanguage(), inRequest.getLocale().getCountry(), inRequest.getLocale().getVariant())));
            statusBuilder.setSessionId(sessionId.getValue());
            responseBuilder.setSessionId(sessionId.getValue());
        }
        catch (Exception e) {
            String message = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (SLF4JLoggerProxy.isDebugEnabled(this)) {
                SLF4JLoggerProxy.warn((Object)this, e, message, new Object[0]);
            } else {
                SLF4JLoggerProxy.warn((Object)this, message);
            }
            statusBuilder.setFailed(true);
            statusBuilder.setMessage(message);
            responseBuilder.setSessionId("null");
        }
        responseBuilder.setStatus(statusBuilder.build());
        BaseRpc.LoginResponse response = responseBuilder.build();
        SLF4JLoggerProxy.trace((Object)this, "Returning {} for {}", response, inRequest.getUsername());
        return response;
    }

    @Override
    public BaseRpc.LogoutResponse logout(RpcController inController, BaseRpc.LogoutRequest inRequest) throws ServiceException {
        SLF4JLoggerProxy.trace((Object)this, "{} received logout request for {}", this.getDescription(), inRequest.getSessionId());
        BaseRpc.LogoutResponse.Builder responseBuilder = BaseRpc.LogoutResponse.newBuilder();
        BaseRpc.Status.Builder statusBuilder = BaseRpc.Status.newBuilder();
        statusBuilder.setFailed(false);
        statusBuilder.setSessionId(inRequest.getSessionId());
        try {
            this.serverServices.logout(inRequest.getSessionId());
        }
        catch (Exception e) {
            if (SLF4JLoggerProxy.isDebugEnabled(this)) {
                SLF4JLoggerProxy.warn((Object)this, e);
            } else {
                SLF4JLoggerProxy.warn((Object)this, ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            statusBuilder.setFailed(true);
            statusBuilder.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        responseBuilder.setStatus(statusBuilder.build());
        BaseRpc.LogoutResponse response = responseBuilder.build();
        SLF4JLoggerProxy.trace((Object)this, "Returning {} for {}", response, inRequest.getSessionId());
        return response;
    }

    @Override
    public BaseRpc.HeartbeatResponse heartbeat(RpcController inController, BaseRpc.HeartbeatRequest inRequest) throws ServiceException {
        SLF4JLoggerProxy.trace((Object)this, "{} received hearbeat request: {}", this.getDescription(), inRequest.getId());
        BaseRpc.HeartbeatResponse.Builder responseBuilder = BaseRpc.HeartbeatResponse.newBuilder();
        try {
            responseBuilder.setId(inRequest.getId());
        }
        catch (Exception e) {
            if (SLF4JLoggerProxy.isDebugEnabled(this)) {
                SLF4JLoggerProxy.warn((Object)this, e);
            }
            SLF4JLoggerProxy.warn((Object)this, ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        BaseRpc.HeartbeatResponse response = responseBuilder.build();
        SLF4JLoggerProxy.trace((Object)this, "Returning {}: {}", response, inRequest.getId());
        return response;
    }

    @Override
    public void setRpcServerServices(RpcServerServices<SessionClazz> inServerServices) {
        this.serverServices = inServerServices;
    }

    protected RpcServerServices<SessionClazz> getServerServices() {
        return this.serverServices;
    }

    protected void setServerServices(RpcServerServices<SessionClazz> inServerServices) {
        this.serverServices = inServerServices;
    }
}

