/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.spring;

import org.marketcetera.util.misc.ClassVersion;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

@ClassVersion(value="$Id: SpringUtils.java 16841 2014-02-20 19:59:04Z colin $")
public final class SpringUtils {
    public static void addStringBean(BeanDefinitionRegistry context, String name, String value) {
        RootBeanDefinition bean = new RootBeanDefinition(String.class);
        bean.setResourceDescription(SpringUtils.class.getName());
        ConstructorArgumentValues values = new ConstructorArgumentValues();
        values.addGenericArgumentValue((Object)value);
        bean.setConstructorArgumentValues(values);
        context.registerBeanDefinition(name, (BeanDefinition)bean);
    }

    public static void addPropertiesConfigurer(BeanDefinitionRegistry inRegistry, String configurerName, String locationRef) {
        RootBeanDefinition bean = new RootBeanDefinition(PropertySourcesPlaceholderConfigurer.class);
        bean.setResourceDescription(SpringUtils.class.getName());
        MutablePropertyValues values = new MutablePropertyValues();
        values.addPropertyValue("locations", (Object)new RuntimeBeanReference(locationRef));
        bean.setPropertyValues(values);
        inRegistry.registerBeanDefinition(configurerName, (BeanDefinition)bean);
    }

    private SpringUtils() {
    }
}

