/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.Messages;

@ClassVersion(value="$Id: UnicodeCharset.java 16154 2012-07-14 16:34:05Z colin $")
public enum UnicodeCharset {
    UTF8("UTF-8"),
    UTF16BE("UTF-16BE"),
    UTF16LE("UTF-16LE"),
    UTF16("UTF-16"),
    UTF32BE("UTF-32BE"),
    UTF32LE("UTF-32LE"),
    UTF32("UTF-32");

    private final String mName;
    private final Charset mCharset;

    private UnicodeCharset(String name) {
        this.mName = name;
        Charset charset = null;
        try {
            charset = Charset.forName(this.getName());
        }
        catch (IllegalArgumentException ex) {
            Messages.UNKNOWN_CHARSET.warn((Object)this, ex, this.getName());
        }
        this.mCharset = charset;
    }

    public String getName() {
        return this.mName;
    }

    public Charset getCharset() {
        return this.mCharset;
    }

    public boolean isSupported() {
        return this.getCharset() != null;
    }

    public void assertSupported() throws I18NException {
        if (!this.isSupported()) {
            throw new I18NException(new I18NBoundMessage1P(Messages.UNKNOWN_CHARSET, (Serializable)((Object)this.getName())));
        }
    }

    public String decode(byte[] data, int offset, int length) throws I18NException {
        if (data == null) {
            return null;
        }
        this.assertSupported();
        return new String(data, offset, length, this.getCharset());
    }

    public String decode(byte[] data) throws I18NException {
        if (data == null) {
            return null;
        }
        this.assertSupported();
        return new String(data, this.getCharset());
    }

    public byte[] encode(String data) throws I18NException {
        if (data == null) {
            return null;
        }
        this.assertSupported();
        return data.getBytes(this.getCharset());
    }
}

