/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.Messages;
import org.marketcetera.util.ws.stateful.SessionFactory;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.tags.NodeId;
import org.marketcetera.util.ws.tags.SessionId;

@ClassVersion(value="$Id: SessionManager.java 17411 2017-04-28 14:50:38Z colin $")
public class SessionManager<T> {
    public static final long MAX_SCAN_INTERVAL = 60000L;
    public static final long INFINITE_SESSION_LIFESPAN = -1L;
    private NodeId mServerId;
    private final long mSessionLife;
    private final SessionFactory<T> mSessionFactory;
    private final Object sessionMapLock = new Object();
    private final HashMap<SessionId, SessionHolder<T>> mMap = new HashMap();

    public SessionManager(SessionFactory<T> sessionFactory, long sessionLife) {
        this.mSessionFactory = sessionFactory;
        this.mSessionLife = sessionLife;
        if (this.getLifespan() != -1L) {
            new Reaper().start();
        }
    }

    public SessionManager(long sessionLife) {
        this(null, sessionLife);
    }

    public SessionManager(SessionFactory<T> sessionFactory) {
        this(sessionFactory, -1L);
    }

    public SessionManager() {
        this(-1L);
    }

    void setServerId(NodeId serverId) {
        this.mServerId = serverId;
    }

    public NodeId getServerId() {
        return this.mServerId;
    }

    public SessionFactory<T> getSessionFactory() {
        return this.mSessionFactory;
    }

    public long getLifespan() {
        return this.mSessionLife;
    }

    protected Map<SessionId, SessionHolder<T>> getMap() {
        return this.mMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(SessionId id, SessionHolder<T> holder) {
        Object object = this.sessionMapLock;
        synchronized (object) {
            holder.markAccess();
            if (this.getSessionFactory() != null) {
                holder.setSession(this.getSessionFactory().createSession(holder.getCreationContext(), holder.getUser(), id));
            }
            this.getMap().put(id, holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionHolder<T> get(SessionId id) {
        Object object = this.sessionMapLock;
        synchronized (object) {
            SessionHolder<T> holder = this.getMap().get(id);
            if (holder == null) {
                return null;
            }
            holder.markAccess();
            return holder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(SessionId id) {
        Object object = this.sessionMapLock;
        synchronized (object) {
            SessionHolder<T> holder = this.getMap().remove(id);
            if (holder != null && this.getSessionFactory() != null) {
                this.getSessionFactory().removedSession(holder.getSession());
            }
        }
    }

    @ClassVersion(value="$Id: SessionManager.java 17411 2017-04-28 14:50:38Z colin $")
    final class Reaper
    extends Thread {
        private long mScanInterval;

        public Reaper() {
            super(Thread.currentThread().getThreadGroup(), Messages.REAPER_THREAD_NAME.getText());
            this.setDaemon(true);
            this.mScanInterval = Math.min(60000L, (long)((double)SessionManager.this.getLifespan() * 0.05));
        }

        private long getScanInterval() {
            return this.mScanInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                long cutoff = System.currentTimeMillis() - SessionManager.this.getLifespan();
                Object object = SessionManager.this.sessionMapLock;
                synchronized (object) {
                    Iterator i = SessionManager.this.getMap().entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        if (entry.getValue().getLastAccess() > cutoff) continue;
                        Messages.REAPER_EXPIRED_SESSION.info(this, entry.getKey(), entry.getValue().getCreationContext());
                        if (SessionManager.this.getSessionFactory() != null) {
                            SessionManager.this.getSessionFactory().removedSession(entry.getValue().getSession());
                        }
                        i.remove();
                    }
                }
                try {
                    Thread.sleep(this.getScanInterval());
                }
                catch (InterruptedException ex) {
                    Messages.REAPER_TERMINATED.info(this, ex, SessionManager.this.getServerId());
                    return;
                }
            }
        }
    }
}

