/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateless;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.jws.WebService;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.PortDescriptor;
import org.marketcetera.util.ws.stateful.UsesPort;
import org.marketcetera.util.ws.tags.NodeId;

@ClassVersion(value="$Id: Node.java 17411 2017-04-28 14:50:38Z colin $")
public class Node
implements UsesPort {
    private String host;
    private int port;
    private final NodeId nodeId = NodeId.generate();
    private String nodeDescription;
    public static final int DEFAULT_PORT = 9000;
    public static final String DEFAULT_SERVER_HOST = "0.0.0.0";
    public static final String DEFAULT_CLIENT_HOST = "127.0.0.1";

    public void setHost(String inHost) {
        this.host = inHost;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int inPort) {
        this.port = inPort;
    }

    public NodeId getId() {
        return this.nodeId;
    }

    public String getNodeDescription() {
        return this.nodeDescription;
    }

    public void setNodeDescription(String inNodeDescription) {
        this.nodeDescription = inNodeDescription;
    }

    @Override
    public Collection<PortDescriptor> getPortDescriptors() {
        return Lists.newArrayList((Object[])new PortDescriptor[]{new PortDescriptor(this.port, this.getNodeDescription())});
    }

    protected Node(String inHost, int inPort) {
        this.host = inHost;
        this.port = inPort;
        this.nodeDescription = this.nodeId.getValue();
    }

    protected Node() {
        this(DEFAULT_SERVER_HOST, 9000);
    }

    protected String getConnectionUrl(Class<?> inInterfaceClazz) {
        String targetNamespace = null;
        for (Annotation annotation : inInterfaceClazz.getDeclaredAnnotations()) {
            if (!(annotation instanceof WebService)) continue;
            WebService webServiceAnnotation = (WebService)annotation;
            targetNamespace = webServiceAnnotation.targetNamespace();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("http://");
        builder.append(this.getHost());
        builder.append(':');
        builder.append(this.getPort());
        builder.append('/');
        if (targetNamespace == null) {
            builder.append(inInterfaceClazz.getName().replace('.', '_').replace('$', '_'));
        } else {
            builder.append(targetNamespace);
        }
        return builder.toString();
    }
}

