/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateless;

import java.util.HashMap;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.ContextClassProvider;
import org.marketcetera.util.ws.stateless.Node;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.stateless.StatelessServiceBase;
import org.marketcetera.util.ws.tags.AppId;
import org.marketcetera.util.ws.tags.VersionId;
import org.marketcetera.util.ws.wrappers.LocaleWrapper;

@ClassVersion(value="$Id: StatelessClient.java 17112 2016-02-11 17:58:19Z colin $")
public class StatelessClient
extends Node {
    private final AppId mAppId;
    private final ContextClassProvider contextClassProvider;

    public StatelessClient(String inHost, int inPort, AppId inAppId, ContextClassProvider inContextClasses) {
        super(inHost, inPort);
        this.mAppId = inAppId;
        this.contextClassProvider = inContextClasses;
    }

    public StatelessClient(String host, int port, AppId appId) {
        this(host, port, appId, null);
    }

    public StatelessClient(AppId appId) {
        this("127.0.0.1", 9000, appId);
    }

    public StatelessClient() {
        this(null);
    }

    public AppId getAppId() {
        return this.mAppId;
    }

    protected void fillContext(StatelessClientContext context) {
        context.setVersionId(VersionId.SELF);
        context.setAppId(this.getAppId());
        context.setClientId(this.getId());
        context.setLocale(new LocaleWrapper(ActiveLocale.getLocale()));
    }

    public StatelessClientContext getContext() {
        StatelessClientContext context = new StatelessClientContext();
        this.fillContext(context);
        return context;
    }

    public <T extends StatelessServiceBase> T getService(Class<T> inInterface) {
        JaxWsProxyFactoryBean f = new JaxWsProxyFactoryBean();
        f.setServiceClass(inInterface);
        f.setAddress(this.getConnectionUrl(inInterface));
        HashMap<String, Class<?>[]> props = f.getProperties();
        if (props == null) {
            props = new HashMap<String, Class<?>[]>();
        }
        if (this.contextClassProvider != null) {
            SLF4JLoggerProxy.debug((Object)this, "Using additional context: {}", this.contextClassProvider);
            props.put("jaxb.additionalContextClasses", this.contextClassProvider.getContextClasses());
        }
        f.setProperties(props);
        StatelessServiceBase service = (StatelessServiceBase)f.create();
        HTTPConduit http = (HTTPConduit)ClientProxy.getClient((Object)service).getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(0L);
        httpClientPolicy.setReceiveTimeout(0L);
        http.setClient(httpClientPolicy);
        return (T)service;
    }
}

