/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateless;

import java.util.HashMap;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.ContextClassProvider;
import org.marketcetera.util.ws.stateless.Messages;
import org.marketcetera.util.ws.stateless.Node;
import org.marketcetera.util.ws.stateless.ServiceInterface;
import org.marketcetera.util.ws.stateless.StatelessServiceBase;

@ClassVersion(value="$Id: StatelessServer.java 17411 2017-04-28 14:50:38Z colin $")
public class StatelessServer
extends Node {
    private final ContextClassProvider contextClassProvider;
    private Server server;
    private JaxWsServerFactoryBean factory;

    public StatelessServer(String inHost, int inPort, ContextClassProvider inContextClassProvider) {
        super(inHost, inPort);
        this.contextClassProvider = inContextClassProvider;
        this.setNodeDescription(Messages.WEB_SERVICE_DESCRIPTION.getText());
    }

    public StatelessServer(String inHostname, int inPort) {
        this(inHostname, inPort, null);
    }

    public StatelessServer() {
        this("0.0.0.0", 9000);
    }

    public <T extends StatelessServiceBase> ServiceInterface publish(T impl, Class<T> iface) {
        this.factory = new JaxWsServerFactoryBean();
        HashMap<String, Class<?>[]> props = this.factory.getProperties();
        if (props == null) {
            props = new HashMap<String, Class<?>[]>();
        }
        if (this.contextClassProvider != null) {
            SLF4JLoggerProxy.debug((Object)this, "Using additional context: {}", this.contextClassProvider);
            props.put("jaxb.additionalContextClasses", this.contextClassProvider.getContextClasses());
        }
        this.factory.setProperties(props);
        this.factory.setServiceClass(iface);
        this.factory.setAddress(this.getConnectionUrl(iface));
        this.factory.setServiceBean(impl);
        this.server = this.factory.create();
        return new ServiceInterface(this.server);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
        if (this.factory != null) {
            this.factory.getBus().shutdown(true);
            this.factory = null;
        }
    }
}

