/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: RemoteProxyException.java 16154 2012-07-14 16:34:05Z colin $")
public class RemoteProxyException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final String[] mTraceCapture;
    private final String mServerString;
    private final String mServerName;

    public RemoteProxyException(String message, String[] traceCapture, String serverString, String serverName) {
        super(message);
        this.mTraceCapture = traceCapture;
        this.mServerString = serverString;
        this.mServerName = serverName;
    }

    public String[] getTraceCapture() {
        return this.mTraceCapture;
    }

    public String getServerName() {
        return this.mServerName;
    }

    @Override
    public void printStackTrace() {
        if (this.getTraceCapture() == null) {
            return;
        }
        for (String frame : this.getTraceCapture()) {
            System.err.println(frame);
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.getTraceCapture() == null) {
            return;
        }
        for (String frame : this.getTraceCapture()) {
            s.println(frame);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.getTraceCapture() == null) {
            return;
        }
        for (String frame : this.getTraceCapture()) {
            s.println(frame);
        }
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return null;
    }

    @Override
    public String toString() {
        return this.mServerString;
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.getMessage()) + ArrayUtils.hashCode((Object)this.getTraceCapture()) + ObjectUtils.hashCode((Object)this.toString()) + ObjectUtils.hashCode((Object)this.getServerName());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        RemoteProxyException o = (RemoteProxyException)other;
        return ObjectUtils.equals((Object)this.getMessage(), (Object)o.getMessage()) && ArrayUtils.isEquals((Object)this.getTraceCapture(), (Object)o.getTraceCapture()) && ObjectUtils.equals((Object)this.toString(), (Object)o.toString()) && ObjectUtils.equals((Object)this.getServerName(), (Object)o.getServerName());
    }
}

