/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.except;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NInterruptedRuntimeException;
import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.except.I18NThrowable;
import org.marketcetera.util.except.I18NThrowableTestBase;
import org.marketcetera.util.except.Messages;
import org.marketcetera.util.except.TestMessages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;

public class I18NInterruptedRuntimeExceptionTest
extends I18NThrowableTestBase {
    private static final I18NThrowable[] ALL = new I18NThrowable[]{new I18NInterruptedRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NInterruptedRuntimeException((Throwable)new InterruptedException(), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), null};

    @Test
    public void empty() {
        I18NInterruptedRuntimeException ex = new I18NInterruptedRuntimeException();
        Assert.assertEquals((Object)Messages.THREAD_INTERRUPTED, (Object)ex.getI18NBoundMessage());
        Assert.assertNull((Object)ex.getCause());
    }

    @Test
    public void causeWithoutMessage() {
        InterruptedException nested = new InterruptedException();
        I18NInterruptedRuntimeException ex = new I18NInterruptedRuntimeException((Throwable)nested);
        Assert.assertEquals((Object)Messages.THREAD_INTERRUPTED, (Object)ex.getI18NBoundMessage());
        Assert.assertEquals((Object)nested, (Object)ex.getCause());
    }

    @Test
    public void myMessage() {
        I18NInterruptedRuntimeExceptionTest.myMessage(new Exception("Test message 1 (expected)"), (I18NThrowable)new I18NInterruptedRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 0);
    }

    @Test
    public void myMessageAndCauseWithoutMessage() {
        InterruptedException nested = new InterruptedException();
        I18NInterruptedRuntimeExceptionTest.myMessageAndCauseWithoutMessage(nested, new Exception("Test message 1 (expected)", nested), (I18NThrowable)new I18NInterruptedRuntimeException((Throwable)nested, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 1);
    }

    @Test
    public void interruptionEmptyNoThrow() throws Exception {
        I18NInterruptedRuntimeException.checkInterruption();
    }

    @Test
    public void interruptionEmptyThrow() {
        Thread.currentThread().interrupt();
        try {
            I18NInterruptedRuntimeException.checkInterruption();
            Assert.fail();
        }
        catch (I18NInterruptedRuntimeException ex) {
            Assert.assertTrue((boolean)Thread.interrupted());
            Assert.assertEquals((String)ex.getDetail(), (Object)Messages.THREAD_INTERRUPTED, (Object)ex.getI18NBoundMessage());
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    public void interruptionNestedNoThrow() throws Exception {
        I18NInterruptedRuntimeException.checkInterruption((Throwable)new InterruptedException());
    }

    @Test
    public void interruptionNestedThrow() {
        InterruptedException nested = new InterruptedException();
        Thread.currentThread().interrupt();
        try {
            I18NInterruptedRuntimeException.checkInterruption((Throwable)nested);
            Assert.fail();
        }
        catch (I18NInterruptedRuntimeException ex) {
            Assert.assertTrue((boolean)Thread.interrupted());
            Assert.assertEquals((String)ex.getDetail(), (Object)Messages.THREAD_INTERRUPTED, (Object)ex.getI18NBoundMessage());
            Assert.assertEquals((Object)nested, (Object)ex.getCause());
        }
    }

    @Test
    public void interruptionI18NMessageNoThrow() throws Exception {
        I18NInterruptedRuntimeException.checkInterruption((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
    }

    @Test
    public void interruptionI18NMessageThrow() {
        Thread.currentThread().interrupt();
        try {
            I18NInterruptedRuntimeException.checkInterruption((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
            Assert.fail();
        }
        catch (I18NInterruptedRuntimeException ex) {
            Assert.assertTrue((boolean)Thread.interrupted());
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")), (Object)ex.getI18NBoundMessage());
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    public void interruptionI18NMessageNestedNoThrow() throws Exception {
        I18NInterruptedRuntimeException.checkInterruption((Throwable)new InterruptedException(), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
    }

    @Test
    public void interruptionI18NMessageNestedThrow() {
        InterruptedException nested = new InterruptedException();
        Thread.currentThread().interrupt();
        try {
            I18NInterruptedRuntimeException.checkInterruption((Throwable)nested, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
            Assert.fail();
        }
        catch (I18NInterruptedRuntimeException ex) {
            Assert.assertTrue((boolean)Thread.interrupted());
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")), (Object)ex.getI18NBoundMessage());
            Assert.assertEquals((Object)nested, (Object)ex.getCause());
        }
    }
}

