/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.misc.NamedThreadFactory;

@ClassVersion(value="$Id$")
public class NamedThreadFactoryTest {
    @Test(expected=NullPointerException.class)
    public void nullPrefix() {
        new NamedThreadFactory(null);
    }

    @Test
    public void prefix() throws Exception {
        String prefix = "prefix";
        NamedThreadFactory testFactory = new NamedThreadFactory("prefix");
        ThreadFactory expectedFactory = Executors.defaultThreadFactory();
        TestRunnable actualRunnable = new TestRunnable();
        Assert.assertFalse((boolean)actualRunnable.isRan());
        Thread actual = testFactory.newThread(actualRunnable);
        TestRunnable expectedRunnable = new TestRunnable();
        Assert.assertFalse((boolean)expectedRunnable.isRan());
        Thread expected = expectedFactory.newThread(expectedRunnable);
        NamedThreadFactoryTest.assertThreadProperties(expected, actual);
        Assert.assertEquals((Object)"prefix1", (Object)actual.getName());
        actual.start();
        actual.join();
        Assert.assertTrue((boolean)actualRunnable.isRan());
        expected.start();
        expected.join();
        Assert.assertTrue((boolean)expectedRunnable.isRan());
        actualRunnable = new TestRunnable();
        actual = testFactory.newThread(actualRunnable);
        NamedThreadFactoryTest.assertThreadProperties(expectedFactory.newThread(new TestRunnable()), actual);
        Assert.assertEquals((Object)"prefix2", (Object)actual.getName());
        ThreadGroup tg = new ThreadGroup("mygroup");
        TestRunnable actualRunnable2 = new TestRunnable();
        TestRunnable expectedRunnable2 = new TestRunnable();
        ArrayList failures = new ArrayList();
        actual = new Thread(tg, "testThread", (ThreadFactory)testFactory, actualRunnable2, expectedFactory, expectedRunnable2, tg, failures){
            final /* synthetic */ ThreadFactory val$testFactory;
            final /* synthetic */ TestRunnable val$actualRunnable2;
            final /* synthetic */ ThreadFactory val$expectedFactory;
            final /* synthetic */ TestRunnable val$expectedRunnable2;
            final /* synthetic */ ThreadGroup val$tg;
            final /* synthetic */ List val$failures;
            {
                this.val$testFactory = threadFactory;
                this.val$actualRunnable2 = testRunnable;
                this.val$expectedFactory = threadFactory2;
                this.val$expectedRunnable2 = testRunnable2;
                this.val$tg = threadGroup;
                this.val$failures = list;
                super(x0, x1);
            }

            @Override
            public void run() {
                try {
                    Thread actual = this.val$testFactory.newThread(this.val$actualRunnable2);
                    Thread expected = this.val$expectedFactory.newThread(this.val$expectedRunnable2);
                    NamedThreadFactoryTest.assertThreadProperties(expected, actual);
                    Assert.assertEquals((Object)"prefix3", (Object)actual.getName());
                    Assert.assertEquals((Object)this.val$tg, (Object)Thread.currentThread().getThreadGroup());
                }
                catch (Exception e) {
                    this.val$failures.add(e);
                }
            }
        };
        actual.start();
        actual.join();
        Assert.assertTrue((String)((Object)failures).toString(), (boolean)failures.isEmpty());
    }

    private static void assertThreadProperties(Thread inExpected, Thread inActual) {
        Assert.assertEquals((Object)inExpected.isDaemon(), (Object)inActual.isDaemon());
        Assert.assertEquals((Object)inExpected.isAlive(), (Object)inActual.isAlive());
        Assert.assertEquals((long)inExpected.getPriority(), (long)inActual.getPriority());
        Assert.assertEquals((Object)inExpected.getThreadGroup(), (Object)inActual.getThreadGroup());
    }

    private static class TestRunnable
    implements Runnable {
        private volatile boolean mRan;

        private TestRunnable() {
        }

        public boolean isRan() {
            return this.mRan;
        }

        @Override
        public void run() {
            this.mRan = true;
        }
    }
}

