/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.junit.Assert;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.OutputStreamWrapper;
import org.marketcetera.util.file.WriterWrapper;
import org.marketcetera.util.unicode.EncoderTestBase;
import org.marketcetera.util.unicode.SignatureCharset;
import org.marketcetera.util.unicode.UnicodeOutputStreamWriter;

public class MemoryEncoderTest
extends EncoderTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encode(WriterCreator creator, SignatureCharset requestedSignatureCharset, SignatureCharset signatureCharset, String string) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (CloseableRegistry r = new CloseableRegistry();){
            r.register((Closeable)new OutputStreamWrapper((OutputStream)os));
            UnicodeOutputStreamWriter writer = creator.create(os);
            r.register((Closeable)new WriterWrapper((Writer)writer));
            Assert.assertEquals((Object)requestedSignatureCharset, (Object)writer.getRequestedSignatureCharset());
            Assert.assertEquals((Object)signatureCharset, (Object)writer.getSignatureCharset());
            writer.write(string);
        }
        return os.toByteArray();
    }

    @Override
    protected byte[] encode(String string) throws Exception {
        return this.encode(new WriterCreator(){

            @Override
            public UnicodeOutputStreamWriter create(OutputStream os) {
                return new UnicodeOutputStreamWriter(os);
            }
        }, null, null, string);
    }

    @Override
    protected byte[] encode(final SignatureCharset sc, String string) throws Exception {
        return this.encode(new WriterCreator(){

            @Override
            public UnicodeOutputStreamWriter create(OutputStream os) {
                return new UnicodeOutputStreamWriter(os, sc);
            }
        }, sc, sc, string);
    }

    @Override
    protected byte[] encode(final Reader reader, SignatureCharset sc, String string) throws Exception {
        return this.encode(new WriterCreator(){

            @Override
            public UnicodeOutputStreamWriter create(OutputStream os) throws Exception {
                return new UnicodeOutputStreamWriter(os, reader);
            }
        }, sc, sc, string);
    }

    private static interface WriterCreator {
        public UnicodeOutputStreamWriter create(OutputStream var1) throws Exception;
    }
}

