/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.test.UnicodeData;
import org.marketcetera.util.unicode.Signature;
import org.marketcetera.util.unicode.SignatureCharset;
import org.marketcetera.util.unicode.UnicodeCharset;

public class SignatureCharsetTest
extends TestCaseBase {
    private static void single(SignatureCharset sc, Signature signature, UnicodeCharset charset, byte[] data) throws Exception {
        Assert.assertTrue((boolean)sc.isSupported());
        sc.assertSupported();
        Assert.assertEquals((Object)signature, (Object)sc.getSignature());
        Assert.assertEquals((Object)charset, (Object)sc.getCharset());
        Assert.assertNull((Object)sc.decode(null));
        Assert.assertNull((Object)sc.encode(null));
        Assert.assertEquals((Object)"Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", (Object)sc.decode(data));
        Assert.assertArrayEquals((byte[])data, (byte[])sc.encode("Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e"));
    }

    @Test
    public void all() throws Exception {
        SignatureCharsetTest.single(SignatureCharset.NONE_UTF8, Signature.NONE, UnicodeCharset.UTF8, UnicodeData.COMBO_UTF8);
        SignatureCharsetTest.single(SignatureCharset.NONE_UTF16BE, Signature.NONE, UnicodeCharset.UTF16BE, UnicodeData.COMBO_UTF16BE);
        SignatureCharsetTest.single(SignatureCharset.NONE_UTF16LE, Signature.NONE, UnicodeCharset.UTF16LE, UnicodeData.COMBO_UTF16LE);
        SignatureCharsetTest.single(SignatureCharset.NONE_UTF32BE, Signature.NONE, UnicodeCharset.UTF32BE, UnicodeData.COMBO_UTF32BE);
        SignatureCharsetTest.single(SignatureCharset.NONE_UTF32LE, Signature.NONE, UnicodeCharset.UTF32LE, UnicodeData.COMBO_UTF32LE);
        SignatureCharsetTest.single(SignatureCharset.UTF8_UTF8, Signature.UTF8, UnicodeCharset.UTF8, ArrayUtils.addAll((byte[])Signature.UTF8.getMark(), (byte[])UnicodeData.COMBO_UTF8));
        SignatureCharsetTest.single(SignatureCharset.UTF16BE_UTF16BE, Signature.UTF16BE, UnicodeCharset.UTF16BE, ArrayUtils.addAll((byte[])Signature.UTF16BE.getMark(), (byte[])UnicodeData.COMBO_UTF16BE));
        SignatureCharsetTest.single(SignatureCharset.UTF16LE_UTF16LE, Signature.UTF16LE, UnicodeCharset.UTF16LE, ArrayUtils.addAll((byte[])Signature.UTF16LE.getMark(), (byte[])UnicodeData.COMBO_UTF16LE));
        SignatureCharsetTest.single(SignatureCharset.UTF32BE_UTF32BE, Signature.UTF32BE, UnicodeCharset.UTF32BE, ArrayUtils.addAll((byte[])Signature.UTF32BE.getMark(), (byte[])UnicodeData.COMBO_UTF32BE));
        SignatureCharsetTest.single(SignatureCharset.UTF32LE_UTF32LE, Signature.UTF32LE, UnicodeCharset.UTF32LE, ArrayUtils.addAll((byte[])Signature.UTF32LE.getMark(), (byte[])UnicodeData.COMBO_UTF32LE));
    }
}

