/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.sample;

import java.io.File;
import java.util.Locale;
import org.apache.log4j.PropertyConfigurator;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.sample.SampleService;
import org.marketcetera.util.ws.sample.SampleStatelessService;
import org.marketcetera.util.ws.stateful.Client;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.tags.AppId;
import org.marketcetera.util.ws.wrappers.MarshalledLocale;

@ClassVersion(value="$Id$")
public class SampleClient
extends TestCaseBase {
    private static final AppId APP_ID = new AppId("SCApp");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)(DIR_ROOT + File.separator + "ws" + File.separator + "sample" + File.separator + "log_client.properties"));
        String user = null;
        char[] password = null;
        MarshalledLocale locale = new MarshalledLocale(null);
        String argument = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-language".equals(args[i])) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing language");
                }
                locale.setLanguage(args[i]);
                continue;
            }
            if ("-country".equals(args[i])) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing country");
                }
                locale.setCountry(args[i]);
                continue;
            }
            if ("-variant".equals(args[i])) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing variant");
                }
                locale.setVariant(args[i]);
                continue;
            }
            if ("-user".equals(args[i])) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing user");
                }
                user = args[i];
                continue;
            }
            if ("-password".equals(args[i])) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing password");
                }
                password = args[i].toCharArray();
                continue;
            }
            if ("-argument".equals(args[i])) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing argument");
                }
                argument = args[i];
                continue;
            }
            throw new IllegalArgumentException("Unknown option: " + args[i]);
        }
        if (locale.getLanguage() != null) {
            ActiveLocale.setProcessLocale((Locale)locale.toLocale());
        }
        Client c = new Client(APP_ID);
        SampleStatelessService statelessService = (SampleStatelessService)c.getService(SampleStatelessService.class);
        SampleService service = (SampleService)c.getService(SampleService.class);
        System.err.println(statelessService.hello((StatelessClientContext)c.getContext(), argument));
        if (user != null) {
            c.login(user, password);
        }
        try {
            System.err.println(service.hello(c.getContext(), argument));
        }
        finally {
            if (c.getContext().getSessionId() != null) {
                c.logout();
            }
        }
    }
}

