/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.sample;

import java.io.File;
import org.apache.log4j.PropertyConfigurator;
import org.marketcetera.util.log.I18NMessage2P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.sample.SampleAuthenticator;
import org.marketcetera.util.ws.sample.SampleMessages;
import org.marketcetera.util.ws.sample.SampleService;
import org.marketcetera.util.ws.sample.SampleServiceImpl;
import org.marketcetera.util.ws.sample.SampleSession;
import org.marketcetera.util.ws.sample.SampleStatelessService;
import org.marketcetera.util.ws.sample.SampleStatelessServiceImpl;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.Server;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.StatelessServiceBase;

@ClassVersion(value="$Id$")
public class SampleServer
extends TestCaseBase {
    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)(DIR_ROOT + File.separator + "ws" + File.separator + "sample" + File.separator + "log_server.properties"));
        String user = null;
        char[] password = null;
        I18NMessage2P greeting = SampleMessages.SHORT_GREETING;
        for (int i = 0; i < args.length; ++i) {
            if ("-user".equals(args[i])) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing user");
                }
                user = args[i];
                continue;
            }
            if ("-password".equals(args[i])) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing password");
                }
                password = args[i].toCharArray();
                continue;
            }
            if ("-longGreeting".equals(args[i])) {
                greeting = SampleMessages.LONG_GREETING;
                continue;
            }
            throw new IllegalArgumentException("Unknown option: " + args[i]);
        }
        Server s = new Server((Authenticator)new SampleAuthenticator(user, password), new SessionManager());
        s.publish((StatelessServiceBase)new SampleStatelessServiceImpl(greeting), SampleStatelessService.class);
        s.publish((StatelessServiceBase)new SampleServiceImpl((SessionManager<SampleSession>)s.getSessionManager(), greeting), SampleService.class);
        s.wait();
    }
}

